/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class PoolingProfile {
    public static final int INITIALISE_NONE = 0;
    public static final int INITIALISE_ONE = 1;
    public static final int INITIALISE_ALL = 2;
    public static final int WHEN_EXHAUSTED_FAIL = 0;
    public static final int WHEN_EXHAUSTED_WAIT = 1;
    public static final int WHEN_EXHAUSTED_GROW = 2;
    public static final int DEFAULT_MAX_POOL_ACTIVE = 5;
    public static final int DEFAULT_MAX_POOL_IDLE = 5;
    public static final long DEFAULT_MAX_POOL_WAIT = 4000L;
    public static final int DEFAULT_POOL_EXHAUSTED_ACTION = 2;
    public static final int DEFAULT_POOL_INITIALISATION_POLICY = 1;
    public static final int DEFAULT_MIN_EVICTION_MILLIS = 1800000;
    public static final int DEFAULT_EVICTION_INTERVAL_MILLIS = -1;
    public static final Map<String, Integer> POOL_EXHAUSTED_ACTIONS = new HashMap<String, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("WHEN_EXHAUSTED_WAIT", 1);
            this.put("WHEN_EXHAUSTED_FAIL", 0);
            this.put("WHEN_EXHAUSTED_GROW", 2);
        }
    };
    public static final Map<String, Integer> POOL_INITIALISATION_POLICIES = new HashMap<String, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("INITIALISE_NONE", 0);
            this.put("INITIALISE_ONE", 1);
            this.put("INITIALISE_ALL", 2);
        }
    };
    private int maxActive = 5;
    private int maxIdle = 5;
    private long maxWait = 4000L;
    private int exhaustedAction = 2;
    private int initialisationPolicy = 1;
    private int minEvictionMillis = 1800000;
    private int evictionCheckIntervalMillis = -1;
    private boolean disabled = false;

    public PoolingProfile() {
    }

    public PoolingProfile(PoolingProfile pp) {
        this.maxActive = pp.getMaxActive();
        this.maxIdle = pp.getMaxIdle();
        this.maxWait = pp.getMaxWait();
        this.exhaustedAction = pp.getExhaustedAction();
        this.initialisationPolicy = pp.getInitialisationPolicy();
        this.disabled = pp.isDisabled();
    }

    public PoolingProfile(int maxActive, int maxIdle, long maxWait, int exhaustedAction, int initialisationPolicy) {
        this.maxActive = maxActive;
        this.maxIdle = maxIdle;
        this.maxWait = maxWait;
        this.exhaustedAction = exhaustedAction;
        this.initialisationPolicy = initialisationPolicy;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public int getExhaustedAction() {
        return this.exhaustedAction;
    }

    public int getInitialisationPolicy() {
        return this.initialisationPolicy;
    }

    public void setInitialisationPolicy(int policy) {
        this.initialisationPolicy = policy;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public void setExhaustedAction(int exhaustedAction) {
        this.exhaustedAction = exhaustedAction;
    }

    public int getMinEvictionMillis() {
        return this.minEvictionMillis;
    }

    public void setMinEvictionMillis(int minEvictionMillis) {
        this.minEvictionMillis = minEvictionMillis;
    }

    public int getEvictionCheckIntervalMillis() {
        return this.evictionCheckIntervalMillis;
    }

    public void setEvictionCheckIntervalMillis(int evictionCheckIntervalMillis) {
        this.evictionCheckIntervalMillis = evictionCheckIntervalMillis;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PoolingProfile) {
            PoolingProfile pp = (PoolingProfile)obj;
            return pp.getMaxActive() == this.maxActive && pp.getEvictionCheckIntervalMillis() == this.evictionCheckIntervalMillis && pp.getMaxIdle() == this.maxIdle && pp.getMaxWait() == this.maxWait && pp.getExhaustedAction() == this.exhaustedAction && pp.getMinEvictionMillis() == this.minEvictionMillis && pp.isDisabled() == this.disabled;
        }
        return false;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)false);
    }
}

