/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv1.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.raml.implv1.model.MimeTypeImpl;
import org.mule.raml.implv1.model.ResourceImpl;
import org.mule.raml.implv1.model.ResponseImpl;
import org.mule.raml.implv1.model.SecurityReferenceImpl;
import org.mule.raml.implv1.model.parameter.ParameterImpl;
import org.mule.raml.interfaces.model.IAction;
import org.mule.raml.interfaces.model.IActionType;
import org.mule.raml.interfaces.model.IMimeType;
import org.mule.raml.interfaces.model.IResource;
import org.mule.raml.interfaces.model.IResponse;
import org.mule.raml.interfaces.model.ISecurityReference;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.raml.model.Action;
import org.raml.model.MimeType;
import org.raml.model.Resource;
import org.raml.model.Response;
import org.raml.model.SecurityReference;
import org.raml.model.parameter.AbstractParam;
import org.raml.model.parameter.Header;
import org.raml.model.parameter.QueryParameter;
import org.raml.model.parameter.UriParameter;

public class ActionImpl
implements IAction {
    Action action;

    public ActionImpl(Action action) {
        this.action = action;
    }

    public IActionType getType() {
        return IActionType.valueOf((String)this.action.getType().name());
    }

    public IResource getResource() {
        Resource resource = this.action.getResource();
        if (resource == null) {
            return null;
        }
        return new ResourceImpl(resource);
    }

    public Map<String, IMimeType> getBody() {
        if (this.action.getBody() == null) {
            return null;
        }
        LinkedHashMap<String, IMimeType> map = new LinkedHashMap<String, IMimeType>();
        for (Map.Entry entry : this.action.getBody().entrySet()) {
            map.put((String)entry.getKey(), new MimeTypeImpl((MimeType)entry.getValue()));
        }
        return map;
    }

    public Map<String, List<IParameter>> getBaseUriParameters() {
        if (this.action.getBaseUriParameters() == null) {
            return null;
        }
        LinkedHashMap<String, List<IParameter>> map = new LinkedHashMap<String, List<IParameter>>();
        for (Map.Entry entry : this.action.getBaseUriParameters().entrySet()) {
            ArrayList<ParameterImpl> list = new ArrayList<ParameterImpl>();
            for (UriParameter parameter : (List)entry.getValue()) {
                list.add(new ParameterImpl((AbstractParam)parameter));
            }
            map.put((String)entry.getKey(), (List<IParameter>)list);
        }
        return map;
    }

    public Map<String, IParameter> getQueryParameters() {
        if (this.action.getQueryParameters() == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, IParameter> map = new LinkedHashMap<String, IParameter>();
        for (Map.Entry entry : this.action.getQueryParameters().entrySet()) {
            map.put((String)entry.getKey(), new ParameterImpl((AbstractParam)entry.getValue()));
        }
        return map;
    }

    public boolean hasBody() {
        return this.action.hasBody();
    }

    public Map<String, IResponse> getResponses() {
        if (this.action.getResponses() == null) {
            return null;
        }
        LinkedHashMap<String, IResponse> map = new LinkedHashMap<String, IResponse>();
        for (Map.Entry entry : this.action.getResponses().entrySet()) {
            map.put((String)entry.getKey(), new ResponseImpl((Response)entry.getValue()));
        }
        return map;
    }

    public Map<String, IParameter> getHeaders() {
        if (this.action.getHeaders() == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, IParameter> map = new LinkedHashMap<String, IParameter>();
        for (Map.Entry entry : this.action.getHeaders().entrySet()) {
            map.put((String)entry.getKey(), new ParameterImpl((AbstractParam)entry.getValue()));
        }
        return map;
    }

    public List<ISecurityReference> getSecuredBy() {
        if (this.action.getSecuredBy() == null) {
            return null;
        }
        ArrayList<ISecurityReference> list = new ArrayList<ISecurityReference>();
        for (SecurityReference securityReference : this.action.getSecuredBy()) {
            list.add(new SecurityReferenceImpl(securityReference));
        }
        return list;
    }

    public List<String> getIs() {
        return this.action.getIs();
    }

    public void cleanBaseUriParameters() {
        this.action.getBaseUriParameters().clear();
    }

    public void setHeaders(Map<String, IParameter> headers) {
        LinkedHashMap<String, Header> map = new LinkedHashMap<String, Header>();
        for (Map.Entry<String, IParameter> entry : headers.entrySet()) {
            map.put(entry.getKey(), (Header)entry.getValue().getInstance());
        }
        this.action.setHeaders(map);
    }

    public void setQueryParameters(Map<String, IParameter> queryParameters) {
        LinkedHashMap<String, QueryParameter> map = new LinkedHashMap<String, QueryParameter>();
        for (Map.Entry<String, IParameter> entry : queryParameters.entrySet()) {
            map.put(entry.getKey(), (QueryParameter)entry.getValue().getInstance());
        }
        this.action.setQueryParameters(map);
    }

    public void setBody(Map<String, IMimeType> body) {
        LinkedHashMap<String, MimeType> map = new LinkedHashMap<String, MimeType>();
        for (Map.Entry<String, IMimeType> entry : body.entrySet()) {
            map.put(entry.getKey(), (MimeType)entry.getValue().getInstance());
        }
        this.action.setBody(map);
    }

    public void addResponse(String s, IResponse iResponse) {
        this.action.getResponses().put(s, (Response)iResponse.getInstance());
    }

    public void addSecurityReference(String securityReferenceName) {
        this.action.getSecuredBy().add(new SecurityReference(securityReferenceName));
    }

    public void addIs(String s) {
        this.action.getIs().add(s);
    }
}

