/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv2.v08.model;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.raml.implv2.v08.model.ActionImpl;
import org.mule.raml.interfaces.model.IAction;
import org.mule.raml.interfaces.model.IActionType;
import org.mule.raml.interfaces.model.IResource;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.raml.v2.api.model.v08.methods.Method;
import org.raml.v2.api.model.v08.resources.Resource;

public class ResourceImpl
implements IResource {
    private Resource resource;

    public ResourceImpl(Resource resource) {
        this.resource = resource;
    }

    public String getRelativeUri() {
        return this.resource.relativeUri().value();
    }

    public String getUri() {
        return this.resource.resourcePath();
    }

    public String getParentUri() {
        return this.getUri().substring(0, this.getUri().length() - this.getRelativeUri().length());
    }

    public IAction getAction(String name) {
        for (Method method : this.resource.methods()) {
            if (!method.method().equals(name)) continue;
            return new ActionImpl(method);
        }
        return null;
    }

    public Map<IActionType, IAction> getActions() {
        LinkedHashMap<IActionType, IAction> map = new LinkedHashMap<IActionType, IAction>();
        for (Method method : this.resource.methods()) {
            map.put(IActionType.valueOf((String)method.method().toUpperCase()), new ActionImpl(method));
        }
        return map;
    }

    public Map<String, IResource> getResources() {
        HashMap<String, IResource> result = new HashMap<String, IResource>();
        for (Resource item : this.resource.resources()) {
            result.put(item.relativeUri().value(), new ResourceImpl(item));
        }
        return result;
    }

    public String getDisplayName() {
        return this.resource.displayName();
    }

    public Map<String, IParameter> getResolvedUriParameters() {
        throw new UnsupportedOperationException();
    }

    public void setParentUri(String parentUri) {
        throw new UnsupportedOperationException();
    }

    public Map<String, List<IParameter>> getBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public void cleanBaseUriParameters() {
        throw new UnsupportedOperationException();
    }
}

