/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.DependencyNode;

public class MuleDomainDependencyGraphTransformer
implements DependencyGraphTransformer {
    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
        IdentityHashMap<DependencyNode, Object> visitedNodes = new IdentityHashMap<DependencyNode, Object>(512);
        this.visitGraph(node, visitedNodes, true);
        return node;
    }

    private void visitGraph(DependencyNode node, Map<DependencyNode, Object> visitedNodes, boolean rootNode) throws RepositoryException {
        if (!this.setVisited(node, visitedNodes)) {
            return;
        }
        if (this.isDomain(node) && !rootNode) {
            this.removeDependencies(node);
        }
        for (DependencyNode child : node.getChildren()) {
            this.visitGraph(child, visitedNodes, false);
        }
    }

    private boolean setVisited(DependencyNode node, Map<DependencyNode, Object> visitedNodes) {
        return visitedNodes.put(node, Boolean.TRUE) == null;
    }

    private void removeDependencies(DependencyNode node) {
        node.setChildren(new ArrayList());
    }

    private boolean isDomain(DependencyNode node) {
        return node != null && node.getArtifact() != null && "mule-domain".equals(node.getArtifact().getClassifier());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return null != obj && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

