/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.BundleScope;

public class BundleDependencyHelper {
    private Map<BundleDescriptor, BundleDependency> dependenciesMap = new HashMap<BundleDescriptor, BundleDependency>();

    public BundleDependency getBundleDependency(DependencyNode node) {
        Artifact artifact = node.getArtifact();
        BundleDescriptor bundleDescriptor = BundleDependencyHelper.artifactToBundleDescriptor(artifact).build();
        BundleDependency cachedValue = this.dependenciesMap.get(bundleDescriptor);
        if (cachedValue != null) {
            return cachedValue;
        }
        String scope = node.getDependency().getScope();
        BundleScope bundleScope = StringUtils.isEmpty((CharSequence)scope) ? BundleScope.COMPILE : BundleScope.valueOf((String)scope.toUpperCase());
        BundleDependency.Builder bundleDependencyBuilder = BundleDependencyHelper.artifactToBundleDependency(node.getArtifact(), bundleScope.name());
        node.getChildren().stream().forEach(childNode -> bundleDependencyBuilder.addTransitiveDependency(this.getBundleDependency((DependencyNode)childNode)));
        return bundleDependencyBuilder.build();
    }

    static BundleDependency.Builder artifactToBundleDependency(Artifact artifact, String scope) {
        BundleDescriptor.Builder bundleDescriptorBuilder = BundleDependencyHelper.artifactToBundleDescriptor(artifact);
        BundleScope bundleScope = StringUtils.isEmpty((CharSequence)scope) ? BundleScope.COMPILE : BundleScope.valueOf((String)scope.toUpperCase());
        BundleDependency.Builder builder = new BundleDependency.Builder().setDescriptor(bundleDescriptorBuilder.build()).setScope(bundleScope);
        if (!scope.equalsIgnoreCase("provided") && artifact.getFile() != null) {
            builder.setBundleUri(artifact.getFile().toURI());
        }
        return builder;
    }

    static BundleDescriptor.Builder artifactToBundleDescriptor(Artifact artifact) {
        BundleDescriptor.Builder bundleDescriptorBuilder = new BundleDescriptor.Builder().setArtifactId(artifact.getArtifactId()).setGroupId(artifact.getGroupId()).setVersion(artifact.getVersion()).setBaseVersion(artifact.getBaseVersion()).setType(artifact.getExtension());
        String classifier = artifact.getClassifier();
        if (!org.eclipse.aether.util.StringUtils.isEmpty((String)classifier)) {
            bundleDescriptorBuilder.setClassifier(classifier);
        }
        return bundleDescriptorBuilder;
    }
}

