/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.store;

import java.io.Serializable;
import java.util.List;
import org.mule.runtime.core.api.store.ListableObjectStore;
import org.mule.runtime.core.api.store.ObjectStoreException;
import org.mule.runtime.core.api.store.PartitionableObjectStore;

public class ObjectStorePartition<T extends Serializable>
implements ListableObjectStore<T> {
    final String partitionName;
    final PartitionableObjectStore<T> partitionedObjectStore;

    public ObjectStorePartition(String partitionName, PartitionableObjectStore<T> partitionedObjectStore) {
        this.partitionName = partitionName;
        this.partitionedObjectStore = partitionedObjectStore;
    }

    @Override
    public boolean contains(Serializable key) throws ObjectStoreException {
        return this.partitionedObjectStore.contains(key, this.partitionName);
    }

    @Override
    public void store(Serializable key, T value) throws ObjectStoreException {
        this.partitionedObjectStore.store(key, value, this.partitionName);
    }

    @Override
    public T retrieve(Serializable key) throws ObjectStoreException {
        return this.partitionedObjectStore.retrieve(key, this.partitionName);
    }

    @Override
    public void clear() throws ObjectStoreException {
        this.partitionedObjectStore.clear(this.partitionName);
    }

    @Override
    public T remove(Serializable key) throws ObjectStoreException {
        return this.partitionedObjectStore.remove(key, this.partitionName);
    }

    @Override
    public boolean isPersistent() {
        return this.partitionedObjectStore.isPersistent();
    }

    @Override
    public void open() throws ObjectStoreException {
        this.partitionedObjectStore.open(this.partitionName);
    }

    @Override
    public void close() throws ObjectStoreException {
        this.partitionedObjectStore.close(this.partitionName);
    }

    @Override
    public List<Serializable> allKeys() throws ObjectStoreException {
        return this.partitionedObjectStore.allKeys(this.partitionName);
    }

    public PartitionableObjectStore<T> getBaseStore() {
        return this.partitionedObjectStore;
    }

    public String getPartitionName() {
        return this.partitionName;
    }
}

