/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.collection;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class ImmutableMapCollector<T, K, V>
implements Collector<T, ImmutableMap.Builder<K, V>, Map<K, V>> {
    private final Function<T, K> keyMapper;
    private final Function<T, V> valueMapper;

    public ImmutableMapCollector(Function<T, K> keyMapper, Function<T, V> valueMapper) {
        this.keyMapper = keyMapper;
        this.valueMapper = valueMapper;
    }

    @Override
    public Supplier<ImmutableMap.Builder<K, V>> supplier() {
        return ImmutableMap::builder;
    }

    @Override
    public BiConsumer<ImmutableMap.Builder<K, V>, T> accumulator() {
        return (builder, value) -> builder.put(this.keyMapper.apply(value), this.valueMapper.apply(value));
    }

    @Override
    public BinaryOperator<ImmutableMap.Builder<K, V>> combiner() {
        return (left, right) -> left.putAll((Map)right.build());
    }

    @Override
    public Function<ImmutableMap.Builder<K, V>, Map<K, V>> finisher() {
        return ImmutableMap.Builder::build;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return ImmutableSet.of();
    }
}

