/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transaction.lookup;

import java.lang.reflect.Method;
import javax.transaction.TransactionManager;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.transaction.TransactionManagerFactory;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsphereTransactionManagerLookupFactory
implements TransactionManagerFactory {
    private static final String FACTORY_CLASS_5_1_AND_ABOVE = "com.ibm.ws.Transaction.TransactionManagerFactory";
    private static final String FACTORY_CLASS_5_0 = "com.ibm.ejs.jts.jta.TransactionManagerFactory";
    private static final String FACTORY_CLASS_4 = "com.ibm.ejs.jts.jta.JTSXA";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public TransactionManager create(MuleConfiguration config) {
        TransactionManager transactionManager;
        Class clazz;
        try {
            this.logger.debug("Trying WebSphere 5.1+: com.ibm.ws.Transaction.TransactionManagerFactory");
            clazz = ClassUtils.loadClass(FACTORY_CLASS_5_1_AND_ABOVE, this.getClass());
            this.logger.info("Found WebSphere 5.1+: com.ibm.ws.Transaction.TransactionManagerFactory");
        }
        catch (ClassNotFoundException ex) {
            this.logger.debug("Could not find WebSphere 5.1+ TransactionManager factory class", (Throwable)ex);
            try {
                this.logger.debug("Trying WebSphere 5.0: com.ibm.ejs.jts.jta.TransactionManagerFactory");
                clazz = ClassUtils.loadClass(FACTORY_CLASS_5_0, this.getClass());
                this.logger.info("Found WebSphere 5.0: com.ibm.ejs.jts.jta.TransactionManagerFactory");
            }
            catch (ClassNotFoundException ex2) {
                this.logger.debug("Could not find WebSphere 5.0 TransactionManager factory class", (Throwable)ex2);
                try {
                    this.logger.debug("Trying WebSphere 4: com.ibm.ejs.jts.jta.JTSXA");
                    clazz = ClassUtils.loadClass(FACTORY_CLASS_4, this.getClass());
                    this.logger.info("Found WebSphere 4: com.ibm.ejs.jts.jta.JTSXA");
                }
                catch (ClassNotFoundException ex3) {
                    this.logger.debug("Could not find WebSphere 4 TransactionManager factory class", (Throwable)ex3);
                    throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)"Couldn't find any WebSphere TransactionManager factory class, neither for WebSphere version 5.1 nor 5.0 nor 4"), (Throwable)ex);
                }
            }
        }
        try {
            Method method = clazz.getMethod("getTransactionManager", null);
            transactionManager = (TransactionManager)method.invoke(null, (Object[])null);
        }
        catch (Exception ex) {
            throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)("Found WebSphere TransactionManager factory class [" + clazz.getName() + "], but couldn't invoke its static 'getTransactionManager' method")), (Throwable)ex);
        }
        return transactionManager;
    }
}

