/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transaction;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.Status;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.transaction.AbstractTransaction;
import org.mule.runtime.core.transaction.IllegalTransactionStateException;
import org.mule.runtime.core.transaction.TransactionStatusException;

public abstract class AbstractSingleResourceTransaction
extends AbstractTransaction {
    protected static Map<Integer, String> txStatusMappings;
    protected volatile Object key;
    protected volatile Object resource;
    protected final AtomicBoolean started = new AtomicBoolean(false);
    protected final AtomicBoolean committed = new AtomicBoolean(false);
    protected final AtomicBoolean rolledBack = new AtomicBoolean(false);
    protected final AtomicBoolean rollbackOnly = new AtomicBoolean(false);

    protected AbstractSingleResourceTransaction(MuleContext muleContext) {
        super(muleContext);
    }

    @Override
    public void begin() throws TransactionException {
        super.begin();
        this.started.compareAndSet(false, true);
    }

    @Override
    public void commit() throws TransactionException {
        super.commit();
        this.committed.compareAndSet(false, true);
    }

    @Override
    public void rollback() throws TransactionException {
        super.rollback();
        this.rolledBack.compareAndSet(false, true);
    }

    @Override
    public int getStatus() throws TransactionStatusException {
        if (this.rolledBack.get()) {
            return 4;
        }
        if (this.committed.get()) {
            return 3;
        }
        if (this.rollbackOnly.get()) {
            return 1;
        }
        if (this.started.get()) {
            return 0;
        }
        return 6;
    }

    @Override
    public Object getResource(Object key) {
        return key != null && this.key == key ? this.resource : null;
    }

    @Override
    public boolean hasResource(Object key) {
        return key != null && this.key == key;
    }

    @Override
    public void bindResource(Object key, Object resource) throws TransactionException {
        if (key == null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionCannotBindToNullKey());
        }
        if (resource == null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionCannotBindNullResource());
        }
        if (this.key != null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionSingleResourceOnly());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Binding " + resource + " to " + key);
        }
        this.key = key;
        this.resource = resource;
    }

    @Override
    public void setRollbackOnly() {
        this.rollbackOnly.set(true);
    }

    @Override
    public String toString() {
        int status;
        try {
            status = this.getStatus();
        }
        catch (TransactionException e) {
            status = -1;
        }
        String statusName = txStatusMappings.get(status);
        if (statusName == null) {
            statusName = "*undefined*";
        }
        return this.getClass().getName() + '@' + this.id + "[status=" + statusName + ", key=" + this.key + ", resource=" + this.resource + "]";
    }

    @Override
    public boolean supports(Object key, Object resource) {
        return this.key == null && this.getKeyType().isAssignableFrom(key.getClass()) && this.getResourceType().isAssignableFrom(resource.getClass()) || this.key != null && this.key == key && this.resource == resource;
    }

    protected Class getResourceType() {
        throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)("Transaction type: " + this.getClass().getName() + " doesn't support supports(..) method")));
    }

    protected Class getKeyType() {
        throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)("Transaction type: " + this.getClass().getName() + " doesn't support supports(..) method")));
    }

    static {
        Field[] fields;
        txStatusMappings = new HashMap<Integer, String>(10);
        for (Field field : fields = Status.class.getFields()) {
            try {
                txStatusMappings.put(field.getInt(Status.class), field.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        txStatusMappings = Collections.unmodifiableMap(txStatusMappings);
    }
}

