/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.streaming.bytes;

import org.mule.runtime.api.util.DataSize;
import org.mule.runtime.extension.api.ExtensionConstants;

public final class InMemoryCursorStreamConfig {
    private final DataSize initialBufferSize;
    private final DataSize bufferSizeIncrement;
    private final DataSize maxInMemorySize;

    public static InMemoryCursorStreamConfig getDefault() {
        DataSize dataSize = new DataSize(256, ExtensionConstants.DEFAULT_STREAMING_BUFFER_DATA_UNIT);
        return new InMemoryCursorStreamConfig(dataSize, dataSize, null);
    }

    public InMemoryCursorStreamConfig(DataSize initialBufferSize, DataSize bufferSizeIncrement, DataSize maxInMemorySize) {
        this.initialBufferSize = initialBufferSize;
        this.bufferSizeIncrement = bufferSizeIncrement;
        this.maxInMemorySize = maxInMemorySize;
    }

    public DataSize getInitialBufferSize() {
        return this.initialBufferSize;
    }

    public DataSize getBufferSizeIncrement() {
        return this.bufferSizeIncrement;
    }

    public DataSize getMaxInMemorySize() {
        return this.maxInMemorySize;
    }
}

