/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.source.polling.watermark;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.store.ObjectStore;
import org.mule.runtime.core.source.polling.MessageProcessorPollingInterceptor;
import org.mule.runtime.core.source.polling.watermark.Watermark;
import org.mule.runtime.core.source.polling.watermark.WatermarkPollingInterceptor;
import org.mule.runtime.core.source.polling.watermark.WatermarkUtils;

public class UpdateExpressionWatermark
extends Watermark
implements Initialisable {
    private final String updateExpression;
    private final MessageProcessorPollingInterceptor interceptor;

    public UpdateExpressionWatermark(ObjectStore<Serializable> objectStore, String variable, String defaultExpression, String updateExpression) {
        super(objectStore, variable, defaultExpression);
        this.updateExpression = updateExpression;
        this.interceptor = new WatermarkPollingInterceptor(this);
    }

    public void initialise() throws InitialisationException {
        ValidationResult result;
        if (!StringUtils.isEmpty((String)this.updateExpression) && !(result = this.muleContext.getExpressionManager().validate(this.updateExpression)).isSuccess()) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)String.format("update-expression requires a valid MEL expression. '%s' was found instead", this.updateExpression)), (Initialisable)this);
        }
    }

    @Override
    protected Object getUpdatedValue(Event event) {
        try {
            return StringUtils.isEmpty((String)this.updateExpression) ? event.getVariable(this.resolveVariable(event)).getValue() : WatermarkUtils.evaluate(this.updateExpression, event, this.muleContext);
        }
        catch (NotSerializableException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public MessageProcessorPollingInterceptor interceptor() {
        return this.interceptor;
    }
}

