/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.security;

import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.security.SecurityProviderNotFoundException;
import org.mule.runtime.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.security.DefaultMuleAuthentication;
import org.mule.runtime.core.api.security.DefaultMuleCredentials;
import org.mule.runtime.core.api.security.SecurityContext;
import org.mule.runtime.core.api.security.UnauthorisedException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.security.AbstractAuthenticationFilter;

public class UsernamePasswordAuthenticationFilter
extends AbstractAuthenticationFilter {
    private String username = "#[mel:message.inboundProperties.username]";
    private String password = "#[mel:message.inboundProperties.password]";

    @Override
    public Event authenticate(Event event) throws SecurityException, SecurityProviderNotFoundException, UnknownAuthenticationTypeException {
        Authentication authResult;
        Authentication authentication = this.getAuthenticationToken(event);
        try {
            authResult = this.getSecurityManager().authenticate(authentication);
        }
        catch (UnauthorisedException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Authentication request for user: " + this.username + " failed: " + e.toString());
            }
            throw new UnauthorisedException(CoreMessages.authFailedForUser(authentication.getPrincipal().toString()), (Throwable)((Object)e));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Authentication success: " + authResult.toString());
        }
        SecurityContext context = this.getSecurityManager().createSecurityContext(authResult);
        context.setAuthentication(authResult);
        event.getSession().setSecurityContext(context);
        return event;
    }

    protected Authentication getAuthenticationToken(Event event) throws UnauthorisedException {
        ExtendedExpressionManager expressionManager = this.muleContext.getExpressionManager();
        Object usernameEval = expressionManager.evaluate(this.username, event).getValue();
        Object passwordEval = expressionManager.evaluate(this.password, event).getValue();
        if (usernameEval == null) {
            throw new UnauthorisedException(CoreMessages.authNoCredentials());
        }
        if (passwordEval == null) {
            throw new UnauthorisedException(CoreMessages.authNoCredentials());
        }
        return new DefaultMuleAuthentication(new DefaultMuleCredentials(usernameEval.toString(), passwordEval.toString().toCharArray()));
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

