/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.exception.MessagingExceptionHandlerAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessorPathElement;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.routing.RoutingException;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.processor.strategy.LegacyAsynchronousProcessingStrategyFactory;
import org.mule.runtime.core.transaction.TransactionCoordination;
import org.mule.runtime.core.util.NotificationUtils;
import org.mule.runtime.core.util.concurrent.ThreadNameHelper;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AsyncDelegateMessageProcessor
extends AbstractMessageProcessorOwner
implements Processor,
Initialisable,
Startable,
Stoppable,
MessagingExceptionHandlerAware {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private AtomicBoolean consumablePayloadWarned = new AtomicBoolean(false);
    protected MessageProcessorChain delegate;
    protected ProcessingStrategyFactory processingStrategyFactory = new LegacyAsynchronousProcessingStrategyFactory();
    protected ProcessingStrategy processingStrategy;
    protected String name;
    private MessagingExceptionHandler messagingExceptionHandler;

    public AsyncDelegateMessageProcessor(MessageProcessorChain delegate) {
        this.delegate = delegate;
    }

    public AsyncDelegateMessageProcessor(MessageProcessorChain delegate, ProcessingStrategyFactory processingStrategyFactory, String name) {
        this.delegate = delegate;
        this.processingStrategyFactory = processingStrategyFactory;
        this.name = name;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.delegate == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("delegate message processor"), (Initialisable)this);
        }
        if (this.processingStrategyFactory == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("processingStrategy"), (Initialisable)this);
        }
        this.processingStrategy = this.processingStrategyFactory.create(this.muleContext, ThreadNameHelper.getPrefix(this.muleContext) + this.name);
        super.initialise();
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.processingStrategy);
        super.start();
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.processingStrategy);
        super.stop();
    }

    @Override
    public Event process(Event event) throws MuleException {
        try {
            return (Event)Mono.just((Object)event).transform((Function)this).block();
        }
        catch (Throwable e) {
            throw Exceptions.rxExceptionToMuleException(e);
        }
    }

    private void assertNotTransactional(Event event) throws RoutingException {
        if (TransactionCoordination.isTransactionActive()) {
            throw new RoutingException(CoreMessages.asyncDoesNotSupportTransactions(), this.delegate);
        }
    }

    @Override
    public Publisher<Event> apply(Publisher<Event> publisher) {
        return Flux.from(publisher).doOnNext(Exceptions.checkedConsumer(event -> this.assertNotTransactional((Event)event))).doOnNext(event -> this.warnConsumablePayload(event.getMessage())).doOnNext(request -> Flux.just((Object)request).map(event1 -> this.updateEventForAsync((Event)event1)).transform(this.processingStrategy.onPipeline(this.flowConstruct, this.delegate, this.messagingExceptionHandler)).onErrorResumeWith(MessagingException.class, (Function)this.messagingExceptionHandler).doOnError(Exceptions.UNEXPECTED_EXCEPTION_PREDICATE, exception -> this.logger.error("Unhandled exception in async processing.", exception)).subscribe());
    }

    private Event updateEventForAsync(Event event) {
        Event newEvent = Event.builder(event).replyToHandler(null).build();
        Event.setCurrentEvent(newEvent);
        return newEvent;
    }

    private void warnConsumablePayload(InternalMessage message) {
        if (this.consumablePayloadWarned.compareAndSet(false, true) && message.getPayload().getDataType().isStreamType()) {
            this.logger.warn(String.format("Using 'async' router with consumable payload (%s) may lead to unexpected results. Please ensure that only one of the branches actually consumes the payload, or transform it by using an <object-to-byte-array-transformer>.", message.getPayload().getValue().getClass().getName()));
        }
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.delegate);
    }

    public ProcessingStrategy getProcessingStrategy() {
        return this.processingStrategy;
    }

    @Override
    public void addMessageProcessorPathElements(MessageProcessorPathElement pathElement) {
        NotificationUtils.addMessageProcessorPathElements(this.delegate, pathElement.addChild(this));
    }

    @Override
    public void setMessagingExceptionHandler(MessagingExceptionHandler messagingExceptionHandler) {
        this.messagingExceptionHandler = messagingExceptionHandler;
        this.delegate.setMessagingExceptionHandler(messagingExceptionHandler);
    }
}

