/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.ComponentLocation;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.processor.InterceptingMessageProcessor;
import org.mule.runtime.core.api.processor.MessageProcessorContainer;
import org.mule.runtime.core.api.processor.MessageRouter;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.OutboundRouter;
import org.mule.runtime.core.api.routing.SelectiveRouter;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.processor.AbstractMuleObjectOwner;
import org.mule.runtime.dsl.api.component.config.ComponentIdentifier;

public abstract class AbstractMessageProcessorOwner
extends AbstractMuleObjectOwner<Processor>
implements Lifecycle,
MuleContextAware,
FlowConstructAware,
AnnotatedObject,
MessageProcessorContainer {
    private final Map<QName, Object> annotations = new ConcurrentHashMap<QName, Object>();

    public final Object getAnnotation(QName name) {
        return this.annotations.get(name);
    }

    public final Map<QName, Object> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    public org.mule.runtime.api.component.ComponentIdentifier getIdentifier() {
        return new org.mule.runtime.api.component.ComponentIdentifier(){

            public String getNamespace() {
                return ((ComponentIdentifier)AbstractMessageProcessorOwner.this.getAnnotation(ComponentIdentifier.ANNOTATION_NAME)).getNamespace();
            }

            public String getName() {
                return ((ComponentIdentifier)AbstractMessageProcessorOwner.this.getAnnotation(ComponentIdentifier.ANNOTATION_NAME)).getName();
            }

            public ComponentIdentifier.ComponentType getComponentType() {
                if (AbstractMessageProcessorOwner.this instanceof MessageSource) {
                    return ComponentIdentifier.ComponentType.SOURCE;
                }
                if (AbstractMessageProcessorOwner.this instanceof OutboundRouter || AbstractMessageProcessorOwner.this instanceof SelectiveRouter || AbstractMessageProcessorOwner.this instanceof MessageRouter) {
                    return ComponentIdentifier.ComponentType.ROUTER;
                }
                if (AbstractMessageProcessorOwner.this instanceof InterceptingMessageProcessor) {
                    return ComponentIdentifier.ComponentType.INTERCEPTING;
                }
                return ComponentIdentifier.ComponentType.PROCESSOR;
            }
        };
    }

    public ComponentLocation getLocation(final String flowPath) {
        if (flowPath == null) {
            return null;
        }
        return new ComponentLocation(){

            public String getPath() {
                return flowPath;
            }

            public Optional<String> getFileName() {
                return Optional.of((String)AbstractMessageProcessorOwner.this.getAnnotation(new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileName")));
            }

            public Optional<Integer> getLineInFile() {
                return Optional.of(Integer.valueOf((Integer)AbstractMessageProcessorOwner.this.getAnnotation(new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileLine"))));
            }
        };
    }

    public final synchronized void setAnnotations(Map<QName, Object> newAnnotations) {
        this.annotations.clear();
        this.annotations.putAll(newAnnotations);
    }

    @Override
    protected List<Processor> getOwnedObjects() {
        return this.getOwnedMessageProcessors();
    }

    protected abstract List<Processor> getOwnedMessageProcessors();
}

