/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.policy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.policy.SourcePolicyParametersTransformer;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.policy.AbstractCompositePolicy;
import org.mule.runtime.core.policy.FailureSourcePolicyResult;
import org.mule.runtime.core.policy.FlowExecutionException;
import org.mule.runtime.core.policy.MessageSourceResponseParametersProcessor;
import org.mule.runtime.core.policy.Policy;
import org.mule.runtime.core.policy.SourcePolicy;
import org.mule.runtime.core.policy.SourcePolicyProcessorFactory;
import org.mule.runtime.core.policy.SuccessSourcePolicyResult;

public class CompositeSourcePolicy
extends AbstractCompositePolicy<SourcePolicyParametersTransformer, MessageSourceResponseParametersProcessor>
implements SourcePolicy {
    private final Processor flowExecutionProcessor;
    private final SourcePolicyProcessorFactory sourcePolicyProcessorFactory;
    private Map<String, Object> originalResponseParameters;
    private Map<String, Object> originalFailureResponseParameters;
    private Event flowExecutionResponse;

    public CompositeSourcePolicy(List<Policy> parameterizedPolicies, Optional<SourcePolicyParametersTransformer> sourcePolicyParametersTransformer, SourcePolicyProcessorFactory sourcePolicyProcessorFactory, Processor flowExecutionProcessor, MessageSourceResponseParametersProcessor messageSourceResponseParametersProcessor) {
        super(parameterizedPolicies, sourcePolicyParametersTransformer, messageSourceResponseParametersProcessor);
        this.sourcePolicyProcessorFactory = sourcePolicyProcessorFactory;
        this.flowExecutionProcessor = flowExecutionProcessor;
    }

    @Override
    protected Event processNextOperation(Event event) throws MuleException {
        try {
            this.flowExecutionResponse = this.flowExecutionProcessor.process(event);
            this.originalResponseParameters = ((MessageSourceResponseParametersProcessor)this.getParametersProcessor()).getSuccessfulExecutionResponseParametersFunction().apply(this.flowExecutionResponse);
            Message message = this.getParametersTransformer().map(parametersTransformer -> parametersTransformer.fromSuccessResponseParametersToMessage(this.originalResponseParameters)).orElseGet(this.flowExecutionResponse::getMessage);
            return Event.builder(event).message((InternalMessage)message).build();
        }
        catch (MessagingException messagingException) {
            this.originalFailureResponseParameters = ((MessageSourceResponseParametersProcessor)this.getParametersProcessor()).getFailedExecutionResponseParametersFunction().apply(messagingException.getEvent());
            Message message = this.getParametersTransformer().map(parametersTransformer -> parametersTransformer.fromFailureResponseParametersToMessage(this.originalFailureResponseParameters)).orElse(messagingException.getEvent().getMessage());
            throw new FlowExecutionException(Event.builder(event).message((InternalMessage)message).build(), messagingException.getCause(), messagingException.getFailingMessageProcessor());
        }
    }

    @Override
    protected Event processPolicy(Policy policy, Processor nextProcessor, Event event) throws Exception {
        Processor defaultSourcePolicy = this.sourcePolicyProcessorFactory.createSourcePolicy(policy, nextProcessor);
        return defaultSourcePolicy.process(event);
    }

    @Override
    public Either<FailureSourcePolicyResult, SuccessSourcePolicyResult> process(Event sourceEvent) throws Exception {
        try {
            Event policiesResultEvent = this.processPolicies(sourceEvent);
            Map<String, Object> responseParameters = this.getParametersTransformer().map(parametersTransformer -> this.concatMaps(this.originalResponseParameters, parametersTransformer.fromMessageToSuccessResponseParameters(policiesResultEvent.getMessage()))).orElse(this.originalResponseParameters);
            return Either.right(new SuccessSourcePolicyResult(policiesResultEvent, responseParameters, (MessageSourceResponseParametersProcessor)this.getParametersProcessor()));
        }
        catch (FlowExecutionException e) {
            Map<String, Object> responseParameters = this.getParametersTransformer().map(parametersTransformer -> this.concatMaps(this.originalFailureResponseParameters, parametersTransformer.fromMessageToErrorResponseParameters(e.getEvent().getMessage()))).orElse(this.originalFailureResponseParameters);
            return Either.left(new FailureSourcePolicyResult(e, responseParameters));
        }
        catch (MessagingException e) {
            Map<String, Object> responseParameters = this.getParametersTransformer().map(parametersTransformer -> this.concatMaps(this.originalFailureResponseParameters, parametersTransformer.fromMessageToErrorResponseParameters(Message.builder().nullPayload().build()))).orElse(this.originalFailureResponseParameters);
            return Either.left(new FailureSourcePolicyResult(e, responseParameters));
        }
    }

    private Map<String, Object> concatMaps(Map<String, Object> originalResponseParameters, Map<String, Object> policyResponseParameters) {
        HashMap<String, Object> concatMap = new HashMap<String, Object>();
        if (originalResponseParameters != null) {
            concatMap.putAll(originalResponseParameters);
        }
        concatMap.putAll(policyResponseParameters);
        return concatMap;
    }
}

