/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.rx;

import java.util.function.BiConsumer;
import java.util.function.Function;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.rx.Exceptions;
import reactor.core.publisher.SynchronousSink;

public final class Operators {
    private Operators() {
    }

    public static BiConsumer<Event, SynchronousSink<Event>> nullSafeMap(Function<Event, Event> mapper) {
        return (t, sink) -> {
            if (t != null) {
                Event r = (Event)mapper.apply((Event)t);
                if (r != null) {
                    sink.next((Object)r);
                } else {
                    sink.error((Throwable)Exceptions.newEventDroppedException(t));
                }
            }
        };
    }

    public static BiConsumer<Event, SynchronousSink<Event>> echoOnNullMap(Function<Event, Event> mapper) {
        return (t, sink) -> {
            if (t != null) {
                Event r = (Event)mapper.apply((Event)t);
                if (r != null) {
                    sink.next((Object)r);
                } else {
                    sink.next(t);
                }
            }
        };
    }
}

