/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.core.internal.streaming.bytes.ByteBufferManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolingByteBufferManager
implements ByteBufferManager,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoolingByteBufferManager.class);
    private final LoadingCache<Integer, ObjectPool<ByteBuffer>> pools = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).removalListener(notification -> {
        block2: {
            try {
                ((ObjectPool)notification.getValue()).close();
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("Found exception trying to dispose buffer pool for capacity " + notification.getKey(), (Throwable)e);
            }
        }
    }).build((CacheLoader)new CacheLoader<Integer, ObjectPool<ByteBuffer>>(){

        public ObjectPool<ByteBuffer> load(Integer capacity) throws Exception {
            return PoolingByteBufferManager.this.createPool(capacity);
        }
    });

    @Override
    public ByteBuffer allocate(int capacity) {
        try {
            return (ByteBuffer)((ObjectPool)this.pools.getUnchecked((Object)capacity)).borrowObject();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not allocate byte buffer"), (Throwable)e);
        }
    }

    @Override
    public void deallocate(ByteBuffer byteBuffer) {
        block3: {
            int capacity = byteBuffer.capacity();
            ObjectPool pool = (ObjectPool)this.pools.getIfPresent((Object)capacity);
            if (pool != null) {
                try {
                    pool.returnObject((Object)byteBuffer);
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block3;
                    LOGGER.debug("Could not deallocate buffer of capacity " + capacity, (Throwable)e);
                }
            }
        }
    }

    public void dispose() {
        this.pools.invalidateAll();
    }

    private ObjectPool<ByteBuffer> createPool(int capacity) {
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        config.maxIdle = 8;
        config.maxActive = -1;
        config.maxWait = -1L;
        config.whenExhaustedAction = (byte)2;
        config.minEvictableIdleTimeMillis = 300000L;
        config.timeBetweenEvictionRunsMillis = 300000L;
        config.testOnBorrow = false;
        config.testOnReturn = false;
        config.testWhileIdle = false;
        GenericObjectPool genericPool = new GenericObjectPool((PoolableObjectFactory)new ByteBufferObjectFactory(capacity), config);
        return genericPool;
    }

    private class ByteBufferObjectFactory
    implements PoolableObjectFactory<ByteBuffer> {
        private final int capacity;

        private ByteBufferObjectFactory(int capacity) {
            this.capacity = capacity;
        }

        public ByteBuffer makeObject() throws Exception {
            return ByteBuffer.allocate(this.capacity);
        }

        public void destroyObject(ByteBuffer obj) throws Exception {
            obj.clear();
        }

        public boolean validateObject(ByteBuffer obj) {
            return false;
        }

        public void activateObject(ByteBuffer obj) throws Exception {
            obj.clear();
        }

        public void passivateObject(ByteBuffer obj) throws Exception {
        }
    }
}

