/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.mule.runtime.api.streaming.exception.StreamingBufferSizeExceededException;
import org.mule.runtime.api.util.DataSize;
import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.core.internal.streaming.bytes.AbstractInputStreamBuffer;
import org.mule.runtime.core.internal.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.internal.streaming.bytes.Range;
import org.mule.runtime.core.streaming.bytes.InMemoryCursorStreamConfig;

public class InMemoryStreamBuffer
extends AbstractInputStreamBuffer {
    private final DataSize bufferSizeIncrement;
    private final DataSize maxBufferSize;

    public InMemoryStreamBuffer(InputStream stream, InMemoryCursorStreamConfig config, ByteBufferManager bufferManager) {
        super(stream, bufferManager, config.getInitialBufferSize().toBytes());
        this.bufferSizeIncrement = config.getBufferSizeIncrement() != null ? config.getBufferSizeIncrement() : new DataSize(0, DataUnit.BYTE);
        this.maxBufferSize = config.getMaxInMemorySize();
    }

    @Override
    protected void doClose() {
    }

    @Override
    protected int getBackwardsData(ByteBuffer dest, Range requiredRange, int length) {
        return this.copy(dest, requiredRange);
    }

    @Override
    protected int consumeForwardData(ByteBuffer buffer) throws IOException {
        if (!buffer.hasRemaining()) {
            buffer = this.expandBuffer(buffer.capacity());
        }
        return this.loadFromStream(buffer);
    }

    @Override
    protected ByteBuffer expandBuffer(int bytesIncrement) {
        if (!this.canBeExpanded()) {
            throw new StreamingBufferSizeExceededException(this.maxBufferSize.toBytes());
        }
        return super.expandBuffer(bytesIncrement);
    }

    @Override
    protected boolean canBeExpanded() {
        if (this.bufferSizeIncrement.getSize() <= 0) {
            return false;
        }
        if (this.maxBufferSize == null) {
            return true;
        }
        return this.getExpandedBufferSize(this.bufferSizeIncrement.toBytes()) <= this.maxBufferSize.toBytes();
    }
}

