/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.execution;

import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.execution.MessageProcessorExecutionInterceptor;
import org.mule.runtime.core.util.ExceptionUtils;

public class ExceptionToMessagingExceptionExecutionInterceptor
implements MessageProcessorExecutionInterceptor {
    private MuleContext muleContext;
    private FlowConstruct flowConstruct;

    @Override
    public Event execute(Processor messageProcessor, Event event) throws MessagingException {
        try {
            return messageProcessor.process(event);
        }
        catch (Exception exception) {
            MessagingException messagingException;
            if (exception instanceof MessagingException) {
                messagingException = (MessagingException)((Object)exception);
                event = ExceptionUtils.createErrorEvent(event, messageProcessor, messagingException, this.muleContext.getErrorTypeLocator());
            } else {
                messagingException = new MessagingException(event, ExceptionUtils.getRootCauseException(exception), messageProcessor);
                messagingException.setProcessedEvent(ExceptionUtils.createErrorEvent(event, messageProcessor, messagingException, this.muleContext.getErrorTypeLocator()));
            }
            if (messagingException.getFailingMessageProcessor() == null) {
                throw ExceptionUtils.putContext(messagingException, messageProcessor, event, this.flowConstruct, this.muleContext);
            }
            throw ExceptionUtils.putContext(messagingException, messagingException.getFailingMessageProcessor(), event, this.flowConstruct, this.muleContext);
        }
        catch (Throwable ex) {
            throw ExceptionUtils.putContext(new MessagingException(event, ex, messageProcessor), messageProcessor, event, this.flowConstruct, this.muleContext);
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }
}

