/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.queue.objectstore;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import org.mule.runtime.core.util.queue.objectstore.TransientQueueInfoDelegate;

@Deprecated
public class DefaultQueueInfoDelegate
implements TransientQueueInfoDelegate {
    protected final int capacity;
    protected final LinkedList<Serializable> list;

    public DefaultQueueInfoDelegate(int capacity) {
        this.capacity = capacity;
        this.list = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putNow(Serializable o) {
        LinkedList<Serializable> linkedList = this.list;
        synchronized (linkedList) {
            this.list.addLast(o);
            this.list.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(Serializable o, int room, long timeout) throws InterruptedException {
        this.checkInterrupted();
        LinkedList<Serializable> linkedList = this.list;
        synchronized (linkedList) {
            if (this.capacity > 0) {
                if (this.capacity <= room) {
                    throw new IllegalStateException("Can not add more objects than the capacity in one time");
                }
                long l1 = timeout > 0L ? System.currentTimeMillis() : 0L;
                long l2 = timeout;
                while (this.list.size() >= this.capacity - room) {
                    if (l2 <= 0L) {
                        return false;
                    }
                    this.list.wait(l2);
                    l2 = timeout - (System.currentTimeMillis() - l1);
                }
            }
            if (o != null) {
                this.list.addLast(o);
            }
            this.list.notifyAll();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable poll(long timeout) throws InterruptedException {
        this.checkInterrupted();
        LinkedList<Serializable> linkedList = this.list;
        synchronized (linkedList) {
            long l1 = timeout > 0L ? System.currentTimeMillis() : 0L;
            long l2 = timeout;
            while (this.list.isEmpty()) {
                if (l2 <= 0L) {
                    return null;
                }
                this.list.wait(l2);
                l2 = timeout - (System.currentTimeMillis() - l1);
            }
            Serializable o = this.list.removeFirst();
            this.list.notifyAll();
            return o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable peek() throws InterruptedException {
        this.checkInterrupted();
        LinkedList<Serializable> linkedList = this.list;
        synchronized (linkedList) {
            if (this.list.isEmpty()) {
                return null;
            }
            return this.list.getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void untake(Serializable item) throws InterruptedException {
        this.checkInterrupted();
        LinkedList<Serializable> linkedList = this.list;
        synchronized (linkedList) {
            this.list.addFirst(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws InterruptedException {
        this.checkInterrupted();
        LinkedList<Serializable> linkedList = this.list;
        synchronized (linkedList) {
            this.list.clear();
        }
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends Serializable> items) {
        LinkedList<Serializable> linkedList = this.list;
        synchronized (linkedList) {
            boolean result = this.list.addAll(items);
            this.list.notifyAll();
            return result;
        }
    }

    private void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }
}

