/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.pool;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.pool.PoolableObjectFactory;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.object.ObjectFactory;
import org.mule.runtime.core.util.pool.CommonsPoolObjectPool;
import org.mule.runtime.core.util.pool.LifecyleEnabledObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLifecycleEnabledObjectPool
extends CommonsPoolObjectPool
implements LifecyleEnabledObjectPool {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultLifecycleEnabledObjectPool.class);
    protected AtomicBoolean started = new AtomicBoolean(false);
    private List items = new LinkedList();

    public DefaultLifecycleEnabledObjectPool(ObjectFactory objectFactory, PoolingProfile poolingProfile, MuleContext muleContext) {
        super(objectFactory, poolingProfile, muleContext);
    }

    @Override
    protected PoolableObjectFactory getPooledObjectFactory() {
        return new LifecycleEnabledPoolabeObjectFactoryAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws MuleException {
        this.started.set(true);
        List list = this.items;
        synchronized (list) {
            Iterator i = this.items.iterator();
            while (i.hasNext()) {
                ((Startable)i.next()).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws MuleException {
        this.started.set(false);
        List list = this.items;
        synchronized (list) {
            Iterator i = this.items.iterator();
            while (i.hasNext()) {
                ((Stoppable)i.next()).stop();
            }
        }
    }

    class LifecycleEnabledPoolabeObjectFactoryAdapter
    implements PoolableObjectFactory {
        LifecycleEnabledPoolabeObjectFactoryAdapter() {
        }

        public void activateObject(Object obj) throws Exception {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroyObject(Object obj) throws Exception {
            if (DefaultLifecycleEnabledObjectPool.this.started.get() && obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if (obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
            List list = DefaultLifecycleEnabledObjectPool.this.items;
            synchronized (list) {
                DefaultLifecycleEnabledObjectPool.this.items.remove(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object makeObject() throws Exception {
            Object object = DefaultLifecycleEnabledObjectPool.this.objectFactory.getInstance(DefaultLifecycleEnabledObjectPool.this.muleContext);
            if (DefaultLifecycleEnabledObjectPool.this.started.get() && object instanceof Startable) {
                ((Startable)object).start();
            }
            List list = DefaultLifecycleEnabledObjectPool.this.items;
            synchronized (list) {
                DefaultLifecycleEnabledObjectPool.this.items.add(object);
            }
            return object;
        }

        public void passivateObject(Object obj) throws Exception {
        }

        public boolean validateObject(Object obj) {
            return true;
        }
    }
}

