/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.util.Copiable;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.routing.MessageSequence;
import org.mule.runtime.core.routing.outbound.ArrayMessageSequence;
import org.mule.runtime.core.routing.outbound.CollectionMessageSequence;
import org.mule.runtime.core.routing.outbound.IteratorMessageSequence;
import org.mule.runtime.core.routing.outbound.NodeListMessageSequence;
import org.mule.runtime.core.util.collection.SplittingStrategy;
import org.w3c.dom.NodeList;

public class EventToMessageSequenceSplittingStrategy
implements SplittingStrategy<Event, MessageSequence<?>> {
    @Override
    public MessageSequence<?> split(Event event) {
        InternalMessage msg = event.getMessage();
        Object payload = msg.getPayload().getValue();
        if (payload instanceof MessageSequence) {
            return (MessageSequence)payload;
        }
        if (payload instanceof Iterator) {
            return new IteratorMessageSequence((Iterator)payload);
        }
        if (payload instanceof Collection) {
            return new CollectionMessageSequence(this.copyCollection((Collection)payload));
        }
        if (payload instanceof Iterable) {
            return new IteratorMessageSequence(((Iterable)payload).iterator());
        }
        if (payload instanceof Object[]) {
            return new ArrayMessageSequence((Object[])payload);
        }
        if (payload instanceof NodeList) {
            return new NodeListMessageSequence((NodeList)payload);
        }
        throw new IllegalArgumentException(CoreMessages.objectNotOfCorrectType(payload != null ? payload.getClass() : null, new Class[]{Iterable.class, Iterator.class, MessageSequence.class, Collection.class}).getMessage());
    }

    private Collection copyCollection(Collection payload) {
        return payload instanceof Copiable ? (Collection)((Copiable)((Object)payload)).copy() : new LinkedList(payload);
    }
}

