/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util;

import java.security.Provider;
import java.security.Security;

public final class SecurityUtils {
    private static final String PREFERED_PROVIDER_NAME = "BC";

    public static String getSecurityModel() {
        return System.getProperty("mule.security.model", "default");
    }

    public static boolean isFipsSecurityModel() {
        return SecurityUtils.getSecurityModel().equals("fips140-2");
    }

    public static boolean isDefaultSecurityModel() {
        return SecurityUtils.getSecurityModel().equals("default");
    }

    public static Provider getDefaultSecurityProvider() {
        String providerName = System.getProperty("mule.security.provider");
        Provider provider = null;
        if (providerName == null) {
            Provider[] providers;
            if (!SecurityUtils.isFipsSecurityModel()) {
                provider = Security.getProvider(PREFERED_PROVIDER_NAME);
            }
            if (provider == null && (providers = Security.getProviders()).length > 0) {
                provider = providers[0];
            }
        } else {
            provider = Security.getProvider(providerName);
        }
        if (provider == null) {
            throw new IllegalStateException("Can't find a suitable security provider. " + (providerName == null ? "" : "Provider name " + providerName + " was not found."));
        }
        return provider;
    }
}

