/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.compression;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.streaming.CursorStreamProvider;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.transformer.compression.AbstractCompressionTransformer;
import org.mule.runtime.core.util.compression.GZipCompression;

public class GZipCompressTransformer
extends AbstractCompressionTransformer {
    public GZipCompressTransformer() {
        this.setStrategy(new GZipCompression());
        this.registerSourceType(DataType.fromType(Serializable.class));
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.registerSourceType(DataType.CURSOR_STREAM_PROVIDER);
        this.setReturnDataType(DataType.OBJECT);
    }

    @Override
    public Object doTransform(Object src, Charset outputEncoding) throws TransformerException {
        try {
            if (src instanceof CursorStreamProvider) {
                return this.getStrategy().compressInputStream((InputStream)((CursorStreamProvider)src).openCursor());
            }
            if (src instanceof InputStream) {
                return this.getStrategy().compressInputStream((InputStream)src);
            }
            byte[] data = src instanceof byte[] ? (byte[])src : (src instanceof String ? ((String)src).getBytes(outputEncoding) : this.muleContext.getObjectSerializer().getExternalProtocol().serialize(src));
            return this.getStrategy().compressByteArray(data);
        }
        catch (Exception ioex) {
            throw new TransformerException(this, (Throwable)ioex);
        }
    }
}

