/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.security;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.security.SecurityProviderNotFoundException;
import org.mule.runtime.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.security.CryptoFailureException;
import org.mule.runtime.core.api.security.EncryptionStrategyNotFoundException;
import org.mule.runtime.core.api.security.SecurityFilter;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.core.api.security.SecurityProvider;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.security.DefaultMuleSecurityManager;
import org.mule.runtime.core.transformer.TransformerTemplate;
import org.mule.runtime.core.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSecurityFilter
implements MuleContextAware,
SecurityFilter {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SecurityManager securityManager;
    protected MuleContext muleContext;
    private String securityProviders;

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public final void initialise() throws InitialisationException {
        if (this.securityManager == null) {
            this.securityManager = this.muleContext.getSecurityManager();
        }
        if (this.securityManager == null) {
            throw new InitialisationException(CoreMessages.authSecurityManagerNotSet(), (Initialisable)this);
        }
        if (this.securityProviders != null) {
            String[] securityProviders;
            DefaultMuleSecurityManager localManager = new DefaultMuleSecurityManager();
            for (String sp : securityProviders = StringUtils.splitAndTrim(this.securityProviders, ",")) {
                SecurityProvider provider = this.securityManager.getProvider(sp);
                if (provider == null) {
                    throw new InitialisationException(CoreMessages.objectNotRegistered("Security Provider", sp), (Initialisable)this);
                }
                localManager.addProvider(provider);
            }
            this.securityManager = localManager;
        }
        this.doInitialise();
    }

    protected void doInitialise() throws InitialisationException {
    }

    @Override
    public void setSecurityManager(SecurityManager manager) {
        this.securityManager = manager;
    }

    @Override
    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public String getSecurityProviders() {
        return this.securityProviders;
    }

    @Override
    public void setSecurityProviders(String providers) {
        this.securityProviders = providers;
    }

    @Override
    public abstract Event doFilter(Event var1) throws SecurityException, UnknownAuthenticationTypeException, CryptoFailureException, SecurityProviderNotFoundException, EncryptionStrategyNotFoundException, InitialisationException;

    protected Event updatePayload(InternalMessage message, Object payload, Event event) throws MuleException {
        TransformerTemplate trans = new TransformerTemplate(message1 -> payload);
        return Event.builder(event).message(this.muleContext.getTransformationService().applyTransformers(event.getMessage(), event, trans)).build();
    }
}

