/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing.outbound;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.routing.RouterResultsHandler;
import org.mule.runtime.core.message.GroupCorrelation;
import org.mule.runtime.core.processor.AbstractInterceptingMessageProcessor;
import org.mule.runtime.core.routing.DefaultRouterResultsHandler;
import org.mule.runtime.core.routing.MessageSequence;
import org.mule.runtime.core.routing.outbound.EventBuilderConfigurer;
import org.mule.runtime.core.routing.outbound.PartitionedMessageSequence;

public abstract class AbstractMessageSequenceSplitter
extends AbstractInterceptingMessageProcessor
implements MuleContextAware {
    protected RouterResultsHandler resultsHandler = new DefaultRouterResultsHandler();
    protected int batchSize;
    protected String counterVariableName;

    @Override
    public final Event process(Event event) throws MuleException {
        if (this.isSplitRequired(event)) {
            MessageSequence<?> seq = this.splitMessageIntoSequence(event);
            if (!seq.isEmpty()) {
                return this.resultsHandler.aggregateResults(this.processParts(seq, event), event);
            }
            this.logger.warn("Splitter returned no results. If this is not expected, please check your split expression");
            return event;
        }
        return this.processNext(event);
    }

    protected boolean isSplitRequired(Event event) {
        return true;
    }

    protected abstract MessageSequence<?> splitMessageIntoSequence(Event var1) throws MuleException;

    protected List<Event> processParts(MessageSequence<?> seq, Event originalEvent) throws MuleException {
        ArrayList<Event> resultEvents = new ArrayList<Event>();
        int correlationSequence = 0;
        MessageSequence<?> messageSequence = seq;
        if (this.batchSize > 1) {
            messageSequence = new PartitionedMessageSequence(seq, this.batchSize);
        }
        Integer count = messageSequence.size();
        Event lastResult = null;
        while (messageSequence.hasNext()) {
            ++correlationSequence;
            Event.Builder builder = Event.builder(originalEvent);
            this.propagateFlowVars(lastResult, builder);
            if (this.counterVariableName != null) {
                builder.addVariable(this.counterVariableName, correlationSequence);
            }
            builder.groupCorrelation(new GroupCorrelation(count, correlationSequence));
            this.initEventBuilder(messageSequence.next(), originalEvent, builder, this.resolvePropagatedFlowVars(lastResult));
            Event event = builder.build();
            Event resultEvent = this.processNext(event);
            if (resultEvent == null) continue;
            resultEvents.add(resultEvent);
            lastResult = resultEvent;
        }
        if (correlationSequence == 1) {
            this.logger.debug("Splitter only returned a single result. If this is not expected, please check your split expression");
        }
        return resultEvents;
    }

    protected Set<String> resolvePropagatedFlowVars(Event lastResult) {
        return Collections.emptySet();
    }

    protected void propagateFlowVars(Event previousResult, Event.Builder builder) {
    }

    private void initEventBuilder(Object payload, Event originalEvent, Event.Builder builder, Set<String> flowVarsFromLastResult) {
        if (payload instanceof EventBuilderConfigurer) {
            ((EventBuilderConfigurer)payload).configure(builder);
        } else if (payload instanceof Event) {
            Event payloadAsEvent = (Event)payload;
            builder.message(payloadAsEvent.getMessage());
            for (String flowVarName : payloadAsEvent.getVariableNames()) {
                if (flowVarsFromLastResult.contains(flowVarName)) continue;
                builder.addVariable(flowVarName, payloadAsEvent.getVariable(flowVarName).getValue(), payloadAsEvent.getVariable(flowVarName).getDataType());
            }
        } else if (payload instanceof InternalMessage) {
            builder.message((InternalMessage)payload);
        } else {
            builder.message(InternalMessage.builder(originalEvent.getMessage()).payload(payload).build());
        }
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setCounterVariableName(String counterVariableName) {
        this.counterVariableName = counterVariableName;
    }
}

