/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.MessageProcessorPathElement;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.expression.ExpressionConfig;
import org.mule.runtime.core.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.routing.CollectionSplitter;
import org.mule.runtime.core.routing.ExpressionSplitter;
import org.mule.runtime.core.routing.MessageFilter;
import org.mule.runtime.core.routing.MessageSequence;
import org.mule.runtime.core.routing.outbound.AbstractMessageSequenceSplitter;
import org.mule.runtime.core.routing.outbound.CollectionMessageSequence;
import org.mule.runtime.core.util.NotificationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class Foreach
extends AbstractMessageProcessorOwner
implements Initialisable,
Processor {
    public static final String ROOT_MESSAGE_PROPERTY = "rootMessage";
    public static final String COUNTER_PROPERTY = "counter";
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<Processor> messageProcessors;
    private Processor ownedMessageProcessor;
    private AbstractMessageSequenceSplitter splitter;
    private MessageFilter filter;
    private String collectionExpression;
    private ExpressionConfig expressionConfig = new ExpressionConfig();
    private int batchSize;
    private String rootMessageVariableName;
    private String counterVariableName;
    private boolean xpathCollection;

    @Override
    public Event process(Event event) throws MuleException {
        InternalMessage transformedMessage;
        String parentMessageProp = this.rootMessageVariableName != null ? this.rootMessageVariableName : ROOT_MESSAGE_PROPERTY;
        Object previousCounterVar = null;
        Object previousRootMessageVar = null;
        if (event.getVariableNames().contains(this.counterVariableName)) {
            previousCounterVar = event.getVariable(this.counterVariableName).getValue();
        }
        if (event.getVariableNames().contains(parentMessageProp)) {
            previousRootMessageVar = event.getVariable(parentMessageProp).getValue();
        }
        InternalMessage message = event.getMessage();
        Event.Builder requestBuilder = Event.builder(event);
        boolean transformed = false;
        if (this.xpathCollection && (transformedMessage = this.transformPayloadIfNeeded(message)) != message) {
            transformed = true;
            message = transformedMessage;
            requestBuilder.message(transformedMessage);
        }
        requestBuilder.addVariable(parentMessageProp, message);
        Event.Builder responseBuilder = Event.builder(this.doProcess(requestBuilder.build()));
        if (transformed) {
            responseBuilder.message(this.transformBack(message));
        } else {
            responseBuilder.message(message);
        }
        if (previousCounterVar != null) {
            responseBuilder.addVariable(this.counterVariableName, previousCounterVar);
        } else {
            responseBuilder.removeVariable(this.counterVariableName);
        }
        if (previousRootMessageVar != null) {
            responseBuilder.addVariable(parentMessageProp, previousRootMessageVar);
        } else {
            responseBuilder.removeVariable(parentMessageProp);
        }
        return responseBuilder.build();
    }

    protected Event doProcess(Event event) throws MuleException, MessagingException {
        try {
            return this.ownedMessageProcessor.process(event);
        }
        catch (MessagingException e) {
            if (this.splitter.equals(e.getFailingMessageProcessor()) || this.filter.equals(e.getFailingMessageProcessor())) {
                e.getInfo().remove("Element");
                throw new MessagingException(event, (Throwable)((Object)e), (Processor)this);
            }
            throw e;
        }
    }

    private InternalMessage transformPayloadIfNeeded(InternalMessage message) throws TransformerException {
        Object payload = message.getPayload().getValue();
        if (payload instanceof Document || payload.getClass().getName().startsWith("org.dom4j.")) {
            return message;
        }
        return this.muleContext.getTransformationService().transform(message, DataType.fromType(Document.class));
    }

    private InternalMessage transformBack(InternalMessage message) throws TransformerException {
        return this.muleContext.getTransformationService().transform(message, DataType.STRING);
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.ownedMessageProcessor);
    }

    @Override
    public void addMessageProcessorPathElements(MessageProcessorPathElement pathElement) {
        NotificationUtils.addMessageProcessorPathElements(this.messageProcessors, pathElement.addChild(this));
    }

    public void setMessageProcessors(List<Processor> messageProcessors) throws MuleException {
        this.messageProcessors = messageProcessors;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.collectionExpression != null) {
            this.expressionConfig.setExpression(this.collectionExpression);
            this.splitter = new ExpressionSplitter(this.expressionConfig){

                @Override
                protected void propagateFlowVars(Event previousResult, Event.Builder builder) {
                    for (String flowVarName : this.resolvePropagatedFlowVars(previousResult)) {
                        builder.addVariable(flowVarName, previousResult.getVariable(flowVarName).getValue(), previousResult.getVariable(flowVarName).getDataType());
                    }
                }

                @Override
                protected Set<String> resolvePropagatedFlowVars(Event previousResult) {
                    return previousResult != null ? previousResult.getVariableNames() : Collections.emptySet();
                }
            };
            if (this.isXPathExpression(this.expressionConfig.getExpression())) {
                this.xpathCollection = true;
            }
        } else {
            this.splitter = new CollectionMapSplitter();
        }
        this.splitter.setBatchSize(this.batchSize);
        this.splitter.setCounterVariableName(this.counterVariableName);
        this.splitter.setMuleContext(this.muleContext);
        ArrayList<Processor> chainProcessors = new ArrayList<Processor>();
        chainProcessors.add(this.splitter);
        chainProcessors.add(MessageProcessors.newChain(this.messageProcessors));
        this.ownedMessageProcessor = new DefaultMessageProcessorChainBuilder().chain(chainProcessors).build();
        super.initialise();
    }

    private boolean isXPathExpression(String expression) {
        return expression.matches("^xpath\\(.+\\)$") || expression.matches("^xpath3\\(.+\\)$");
    }

    public void setCollectionExpression(String expression) {
        this.collectionExpression = expression;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setRootMessageVariableName(String rootMessageVariableName) {
        this.rootMessageVariableName = rootMessageVariableName;
    }

    public void setCounterVariableName(String counterVariableName) {
        this.counterVariableName = counterVariableName;
    }

    private static class CollectionMapSplitter
    extends CollectionSplitter {
        private CollectionMapSplitter() {
        }

        @Override
        protected MessageSequence<?> splitMessageIntoSequence(Event event) {
            Object payload = event.getMessage().getPayload().getValue();
            if (payload instanceof Map) {
                LinkedList<Event> list = new LinkedList<Event>();
                Set set = ((Map)payload).entrySet();
                for (Map.Entry entry : set) {
                    list.add(Event.builder(event).message(InternalMessage.builder().payload(entry.getValue()).build()).build());
                }
                return new CollectionMessageSequence(list);
            }
            return super.splitMessageIntoSequence(event);
        }

        @Override
        protected void propagateFlowVars(Event previousResult, Event.Builder builder) {
            for (String flowVarName : this.resolvePropagatedFlowVars(previousResult)) {
                builder.addVariable(flowVarName, previousResult.getVariable(flowVarName).getValue(), previousResult.getVariable(flowVarName).getDataType());
            }
        }

        @Override
        protected Set<String> resolvePropagatedFlowVars(Event previousResult) {
            return previousResult != null ? previousResult.getVariableNames() : Collections.emptySet();
        }
    }
}

