/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor.strategy;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.scheduler.SchedulerConfig;
import org.mule.runtime.core.processor.strategy.ProactorProcessingStrategyFactory;
import org.mule.runtime.core.processor.strategy.SynchronousProcessingStrategyFactory;
import org.mule.runtime.core.transaction.TransactionCoordination;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class DefaultFlowProcessingStrategyFactory
extends ProactorProcessingStrategyFactory {
    @Override
    public ProcessingStrategy create(MuleContext muleContext, String schedulersNamePrefix) {
        return new DefaultFlowProcessingStrategy(() -> muleContext.getSchedulerService().cpuLightScheduler(SchedulerConfig.config().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.CPU_LITE.name())), () -> muleContext.getSchedulerService().ioScheduler(SchedulerConfig.config().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.BLOCKING.name())), () -> muleContext.getSchedulerService().cpuIntensiveScheduler(SchedulerConfig.config().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.CPU_INTENSIVE.name())), scheduler -> scheduler.stop((long)muleContext.getConfiguration().getShutdownTimeout(), TimeUnit.MILLISECONDS), this.getMaxConcurrency(), () -> muleContext.getSchedulerService().customScheduler(SchedulerConfig.config().withName(schedulersNamePrefix + RING_BUFFER_SCHEDULER_NAME_SUFFIX).withMaxConcurrentTasks(this.getSubscriberCount() + 1)), this.getBufferSize(), this.getSubscriberCount(), this.getWaitStrategy(), muleContext);
    }

    static class DefaultFlowProcessingStrategy
    extends ProactorProcessingStrategyFactory.ProactorProcessingStrategy {
        protected DefaultFlowProcessingStrategy(Supplier<Scheduler> cpuLightSchedulerSupplier, Supplier<Scheduler> blockingSchedulerSupplier, Supplier<Scheduler> cpuIntensiveSchedulerSupplier, Consumer<Scheduler> schedulerStopper, int maxConcurrency, Supplier<Scheduler> ringBufferSchedulerSupplier, int bufferSize, int subscriberCount, String waitStrategy, MuleContext muleContext) {
            super(cpuLightSchedulerSupplier, blockingSchedulerSupplier, cpuIntensiveSchedulerSupplier, schedulerStopper, maxConcurrency, ringBufferSchedulerSupplier, bufferSize, subscriberCount, waitStrategy, muleContext);
        }

        @Override
        public Sink createSink(FlowConstruct flowConstruct, Function<Publisher<Event>, Publisher<Event>> function) {
            Sink proactorSink = super.createSink(flowConstruct, function);
            Sink syncSink = SynchronousProcessingStrategyFactory.SYNCHRONOUS_PROCESSING_STRATEGY_INSTANCE.createSink(flowConstruct, function);
            return new DelegateSink(syncSink, proactorSink);
        }

        @Override
        protected Consumer<Event> createOnEventConsumer() {
            return event -> {};
        }

        @Override
        protected Predicate<Scheduler> scheduleOverridePredicate() {
            return scheduler -> TransactionCoordination.isTransactionActive();
        }

        private static final class DelegateSink
        implements Sink,
        Disposable {
            private final Sink syncSink;
            private final Sink proactorSink;

            public DelegateSink(Sink syncSink, Sink proactorSink) {
                this.syncSink = syncSink;
                this.proactorSink = proactorSink;
            }

            @Override
            public void accept(Event event) {
                if (TransactionCoordination.isTransactionActive()) {
                    this.syncSink.accept(event);
                } else {
                    this.proactorSink.accept(event);
                }
            }

            public void dispose() {
                LifecycleUtils.disposeIfNeeded(this.syncSink, (Logger)NOPLogger.NOP_LOGGER);
                LifecycleUtils.disposeIfNeeded(this.proactorSink, (Logger)NOPLogger.NOP_LOGGER);
            }
        }
    }
}

