/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor.interceptor;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.mule.runtime.api.component.ComponentLocation;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.interception.InterceptionAction;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.construct.MessageProcessorPathResolver;
import org.mule.runtime.core.api.interception.DefaultInterceptionEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.processor.interceptor.ReactiveInterceptionAction;
import org.mule.runtime.dsl.api.component.config.ComponentIdentifier;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ReactiveInterceptorAdapter
implements BiFunction<Processor, Function<Publisher<Event>, Publisher<Event>>, Function<Publisher<Event>, Publisher<Event>>>,
FlowConstructAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveInterceptorAdapter.class);
    private static final String AROUND_METHOD_NAME = "around";
    private ProcessorInterceptor interceptor;
    private FlowConstruct flowConstruct;

    public ReactiveInterceptorAdapter(ProcessorInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    @Override
    public Function<Publisher<Event>, Publisher<Event>> apply(Processor component, Function<Publisher<Event>, Publisher<Event>> next) {
        if (!this.isInterceptable(component)) {
            return next;
        }
        org.mule.runtime.api.component.ComponentIdentifier componentIdentifier = ((AnnotatedObject)component).getIdentifier();
        ComponentLocation componentLocation = ((AnnotatedObject)component).getLocation(((MessageProcessorPathResolver)((Object)this.flowConstruct)).getProcessorPath(component));
        Map dslParameters = (Map)((AnnotatedObject)component).getAnnotation(ComponentIdentifier.ANNOTATION_PARAMETERS);
        LOGGER.debug("Applying interceptor: {} for componentLocation: {}", (Object)this.interceptor, (Object)componentLocation.getPath());
        if (this.interceptor.intercept(componentIdentifier, componentLocation)) {
            if (this.implementsAround()) {
                return publisher -> Mono.from((Publisher)publisher).map(this.doBefore(component, dslParameters)).flatMap(event -> Mono.fromFuture(this.doAround((Event)event, component, dslParameters, next)).mapError(CompletionException.class, completionException -> completionException.getCause())).doOnError(MessagingException.class, error -> this.interceptor.after((InterceptionEvent)new DefaultInterceptionEvent(error.getEvent()), Optional.of(error.getCause()))).map(this.doAfter());
            }
            return publisher -> Mono.from((Publisher)publisher).map(this.doBefore(component, dslParameters)).transform(next).doOnError(MessagingException.class, error -> this.interceptor.after((InterceptionEvent)new DefaultInterceptionEvent(error.getEvent()), Optional.of(error.getCause()))).map(this.doAfter());
        }
        return next;
    }

    private boolean implementsAround() {
        try {
            return !this.interceptor.getClass().getMethod(AROUND_METHOD_NAME, Map.class, InterceptionEvent.class, InterceptionAction.class).isDefault();
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private Function<Event, Event> doBefore(Processor component, Map<String, String> dslParameters) {
        return event -> {
            DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent((Event)event);
            this.interceptor.before(this.resolveParameters((Event)event, component, dslParameters), (InterceptionEvent)interceptionEvent);
            return interceptionEvent.resolve();
        };
    }

    private CompletableFuture<Event> doAround(Event event, Processor component, Map<String, String> dslParameters, Function<Publisher<Event>, Publisher<Event>> next) {
        DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(event);
        ReactiveInterceptionAction reactiveInterceptionAction = new ReactiveInterceptionAction(interceptionEvent, next);
        return this.interceptor.around(this.resolveParameters(event, component, dslParameters), (InterceptionEvent)interceptionEvent, (InterceptionAction)reactiveInterceptionAction).thenApply(interceptedEvent -> ((DefaultInterceptionEvent)interceptedEvent).resolve());
    }

    private Function<Event, Event> doAfter() {
        return event -> {
            DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent((Event)event);
            this.interceptor.after((InterceptionEvent)interceptionEvent, Optional.empty());
            return interceptionEvent.resolve();
        };
    }

    private boolean isInterceptable(Processor component) {
        ComponentLocation componentLocation;
        return component instanceof AnnotatedObject && (componentLocation = ((AnnotatedObject)component).getLocation(((MessageProcessorPathResolver)((Object)this.flowConstruct)).getProcessorPath(component))) != null;
    }

    private Map<String, Object> resolveParameters(Event event, Processor processor, Map<String, String> parameters) {
        HashMap<String, Object> resolvedParameters = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String paramValue = entry.getValue();
            MuleContext muleContext = this.flowConstruct.getMuleContext();
            Object value = muleContext.getExpressionManager().isExpression(paramValue) ? muleContext.getExpressionManager().evaluate(paramValue, event, this.flowConstruct).getValue() : String.valueOf(paramValue);
            resolvedParameters.put(entry.getKey(), value);
        }
        return resolvedParameters;
    }
}

