/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.policy;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.policy.OperationPolicyParametersTransformer;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.policy.AbstractCompositePolicy;
import org.mule.runtime.core.policy.OperationExecutionFunction;
import org.mule.runtime.core.policy.OperationParametersProcessor;
import org.mule.runtime.core.policy.OperationPolicy;
import org.mule.runtime.core.policy.OperationPolicyProcessorFactory;
import org.mule.runtime.core.policy.Policy;

public class CompositeOperationPolicy
extends AbstractCompositePolicy<OperationPolicyParametersTransformer, OperationParametersProcessor>
implements OperationPolicy {
    private final Processor nextOperation = event -> {
        try {
            HashMap<String, Object> parametersMap = new HashMap<String, Object>();
            parametersMap.putAll(operationParametersProcessor.getOperationParameters());
            if (operationPolicyParametersTransformer.isPresent()) {
                parametersMap.putAll(((OperationPolicyParametersTransformer)operationPolicyParametersTransformer.get()).fromMessageToParameters(event.getMessage()));
            }
            return operationExecutionFunction.execute(parametersMap, event);
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DefaultMuleException(e);
        }
    };
    private final OperationPolicyProcessorFactory operationPolicyProcessorFactory;
    private Event nextOperationResponse;

    public CompositeOperationPolicy(List<Policy> parameterizedPolicies, Optional<OperationPolicyParametersTransformer> operationPolicyParametersTransformer, OperationPolicyProcessorFactory operationPolicyProcessorFactory, OperationParametersProcessor operationParametersProcessor, OperationExecutionFunction operationExecutionFunction) {
        super(parameterizedPolicies, operationPolicyParametersTransformer, operationParametersProcessor);
        this.operationPolicyProcessorFactory = operationPolicyProcessorFactory;
    }

    @Override
    protected Event processNextOperation(Event event) throws MuleException {
        this.nextOperationResponse = this.nextOperation.process(event);
        return this.nextOperationResponse;
    }

    @Override
    protected Event processPolicy(Policy policy, Processor nextProcessor, Event event) throws Exception {
        Processor defaultOperationPolicy = this.operationPolicyProcessorFactory.createOperationPolicy(policy, nextProcessor);
        defaultOperationPolicy.process(event);
        return this.nextOperationResponse;
    }

    @Override
    public Event process(Event operationEvent) throws Exception {
        InternalMessage message = this.getParametersTransformer().isPresent() ? ((OperationPolicyParametersTransformer)this.getParametersTransformer().get()).fromParametersToMessage(((OperationParametersProcessor)this.getParametersProcessor()).getOperationParameters()) : operationEvent.getMessage();
        return this.processPolicies(Event.builder(operationEvent).message(message).build());
    }
}

