/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.management.stats;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.management.stats.ProcessingTime;
import org.mule.runtime.core.management.stats.ProcessingTimeWatcher;
import org.mule.runtime.core.util.concurrent.ThreadNameHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProcessingTimeWatcher
implements ProcessingTimeWatcher,
MuleContextAware {
    private static final Logger logger = LoggerFactory.getLogger(DefaultProcessingTimeWatcher.class);
    private final ReferenceQueue<ProcessingTime> queue = new ReferenceQueue();
    private final Map<ProcessingTimeReference, Object> refs = new ConcurrentHashMap<ProcessingTimeReference, Object>();
    private Thread watcherThread;
    private MuleContext muleContext;

    @Override
    public void addProcessingTime(ProcessingTime processingTime) {
        this.refs.put(new ProcessingTimeReference(processingTime, this.queue), this.refs);
    }

    public void start() throws MuleException {
        String threadName = String.format("%sprocessing.time.monitor", ThreadNameHelper.getPrefix(this.muleContext));
        this.watcherThread = new Thread((Runnable)new ProcessingTimeChecker(), threadName);
        this.watcherThread.setDaemon(true);
        this.watcherThread.start();
    }

    public void stop() throws MuleException {
        if (this.watcherThread != null) {
            this.watcherThread.interrupt();
        }
        this.refs.clear();
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    static class ProcessingTimeReference
    extends WeakReference<ProcessingTime> {
        private FlowConstructStatistics statistics;
        private AtomicLong accumulator;

        ProcessingTimeReference(ProcessingTime time, ReferenceQueue<ProcessingTime> queue) {
            super(time, queue);
            this.statistics = time.getStatistics();
            this.accumulator = time.getAccumulator();
        }

        public AtomicLong getAccumulator() {
            return this.accumulator;
        }

        public FlowConstructStatistics getStatistics() {
            return this.statistics;
        }
    }

    private class ProcessingTimeChecker
    implements Runnable {
        private ProcessingTimeChecker() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        ProcessingTimeReference ref = (ProcessingTimeReference)DefaultProcessingTimeWatcher.this.queue.remove();
                        DefaultProcessingTimeWatcher.this.refs.remove(ref);
                        FlowConstructStatistics stats = ref.getStatistics();
                        if (!stats.isEnabled()) continue;
                        stats.addCompleteFlowExecutionTime(ref.getAccumulator().longValue());
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception ex) {
                    logger.error("Error running {}. Thread will be stopped", (Object)this, (Object)ex);
                    continue;
                }
                break;
            }
        }
    }
}

