/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.ScheduledExecutorService;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.internal.streaming.bytes.AbstractInputStreamBuffer;
import org.mule.runtime.core.internal.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.internal.streaming.bytes.FileStoreInputStreamBuffer;
import org.mule.runtime.core.internal.streaming.bytes.InMemoryStreamBuffer;
import org.mule.runtime.core.internal.streaming.bytes.Range;
import org.mule.runtime.core.streaming.bytes.FileStoreCursorStreamConfig;
import org.mule.runtime.core.streaming.bytes.InMemoryCursorStreamConfig;

public class SwitchingInputStreamBuffer
extends AbstractInputStreamBuffer {
    private AbstractInputStreamBuffer delegate;
    private final FileStoreCursorStreamConfig config;
    private final ScheduledExecutorService executorService;

    public static SwitchingInputStreamBuffer of(InputStream stream, FileStoreCursorStreamConfig config, ByteBufferManager bufferManager, ScheduledExecutorService executorService) {
        InMemoryStreamBuffer delegate = new InMemoryStreamBuffer(stream, new InMemoryCursorStreamConfig(config.getMaxInMemorySize(), null, null), bufferManager);
        return new SwitchingInputStreamBuffer(stream, delegate, config, bufferManager, executorService);
    }

    private SwitchingInputStreamBuffer(InputStream stream, AbstractInputStreamBuffer delegate, FileStoreCursorStreamConfig config, ByteBufferManager bufferManager, ScheduledExecutorService executorService) {
        super(stream, SwitchingInputStreamBuffer.openStreamChannel(stream), bufferManager, delegate.getBuffer());
        this.delegate = delegate;
        this.config = config;
        this.executorService = executorService;
    }

    @Override
    protected void doClose() {
        this.delegate.doClose();
    }

    @Override
    protected int getBackwardsData(ByteBuffer dest, Range requiredRange, int length) {
        return this.delegate.getBackwardsData(dest, requiredRange, length);
    }

    @Override
    protected int consumeForwardData(ByteBuffer buffer) throws IOException {
        if (!buffer.hasRemaining() && this.canBeExpanded()) {
            this.switchDelegate();
        }
        return this.delegate.consumeForwardData(buffer);
    }

    @Override
    protected boolean canBeExpanded() {
        return this.delegate instanceof InMemoryStreamBuffer;
    }

    @Override
    protected void acquireBufferLock() {
        super.acquireBufferLock();
        try {
            this.delegate.acquireBufferLock();
        }
        catch (Exception e) {
            super.releaseBufferLock();
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    @Override
    protected void releaseBufferLock() {
        try {
            super.releaseBufferLock();
        }
        finally {
            this.delegate.releaseBufferLock();
        }
    }

    private void switchDelegate() throws IOException {
        ByteBuffer buffer = this.getBuffer();
        buffer.position(0);
        FileStoreInputStreamBuffer newDelegate = new FileStoreInputStreamBuffer(this.getStream(), this.getStreamChannel(), this.config, buffer, this.getBufferManager(), this.executorService);
        AbstractInputStreamBuffer oldDelegate = this.delegate;
        this.delegate = newDelegate;
        try {
            oldDelegate.releaseBufferLock();
            oldDelegate.yield();
            oldDelegate.close();
        }
        catch (Exception e) {
            newDelegate.close();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new MuleRuntimeException((Throwable)e);
        }
    }
}

