/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import java.util.Optional;
import org.mule.runtime.api.util.Preconditions;

class Range {
    final long start;
    final long end;

    protected Range(long start, long end) {
        Preconditions.checkArgument((end >= start ? 1 : 0) != 0, (String)"end has to be greater than start");
        this.start = start;
        this.end = end;
    }

    protected Range advance(int offset) {
        return new Range(this.end, this.end + (long)offset);
    }

    protected boolean contains(Range range) {
        return this.start <= range.start && this.end >= range.end;
    }

    protected boolean isAhead(Range range) {
        return this.start > range.start && this.end >= range.end;
    }

    protected boolean isBehind(Range range) {
        return this.end < range.end;
    }

    protected boolean startsAfter(Range range) {
        return this.start > range.end;
    }

    protected Optional<Range> overlap(Range range) {
        long end;
        long start = Math.max(this.start, range.start);
        if (start <= (end = Math.min(this.end, range.end))) {
            Range overlap = new Range(start, end);
            return this.contains(overlap) ? Optional.of(overlap) : Optional.empty();
        }
        return Optional.empty();
    }

    protected int length() {
        return Math.toIntExact(this.end - this.start);
    }

    protected boolean isEmpty() {
        return this.start == this.end;
    }
}

