/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import java.io.InputStream;
import org.mule.runtime.api.streaming.CursorStream;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.internal.streaming.bytes.AbstractCursorStreamProviderAdapter;
import org.mule.runtime.core.internal.streaming.bytes.BufferedCursorStream;
import org.mule.runtime.core.internal.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.internal.streaming.bytes.InMemoryStreamBuffer;
import org.mule.runtime.core.streaming.bytes.InMemoryCursorStreamConfig;

public class InMemoryCursorStreamProvider
extends AbstractCursorStreamProviderAdapter {
    private final InMemoryStreamBuffer buffer;
    private final int bufferSize;

    public InMemoryCursorStreamProvider(InputStream wrappedStream, InMemoryCursorStreamConfig config, ByteBufferManager bufferManager, Event event) {
        super(wrappedStream, bufferManager, event);
        this.buffer = new InMemoryStreamBuffer(wrappedStream, config, bufferManager);
        this.bufferSize = config.getInitialBufferSize().toBytes();
    }

    @Override
    protected CursorStream doOpenCursor() {
        return new BufferedCursorStream(this.buffer, this.getBufferManager(), this.bufferSize, this);
    }

    @Override
    public void releaseResources() {
        if (this.buffer != null) {
            this.buffer.close();
        }
    }
}

