/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.internal.streaming.bytes.AbstractInputStreamBuffer;
import org.mule.runtime.core.internal.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.internal.streaming.bytes.Range;
import org.mule.runtime.core.streaming.bytes.FileStoreCursorStreamConfig;

public final class FileStoreInputStreamBuffer
extends AbstractInputStreamBuffer {
    private static final String TEMP_DIR_SYSTEM_PROPERTY = "java.io.tmpdir";
    private static final File TEMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private static Random RANDOM = new SecureRandom();
    private final File bufferFile;
    private final RandomAccessFile fileStore;
    private final Lock fileStoreLock = new ReentrantLock();
    private final ScheduledExecutorService executorService;

    public FileStoreInputStreamBuffer(InputStream stream, ReadableByteChannel streamChannel, FileStoreCursorStreamConfig config, ByteBuffer alreadyFetched, ByteBufferManager bufferManager, ScheduledExecutorService executorService) {
        super(stream, streamChannel, bufferManager, config.getMaxInMemorySize().toBytes());
        this.executorService = executorService;
        this.bufferFile = this.createBufferFile("stream-buffer");
        try {
            this.fileStore = new RandomAccessFile(this.bufferFile, "rw");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(String.format("Buffer file %s was just created but now it doesn't exist", this.bufferFile.getAbsolutePath()));
        }
        if (alreadyFetched != null) {
            this.consume(alreadyFetched);
            alreadyFetched.position(0);
            this.persistInFileStore(alreadyFetched);
        }
    }

    @Override
    protected int getBackwardsData(ByteBuffer dest, Range requiredRange, int length) {
        this.releaseBufferLock();
        return this.checked(() -> this.withFileLock(() -> this.fileStore.getChannel().read(dest, requiredRange.start)));
    }

    @Override
    protected boolean canBeExpanded() {
        return false;
    }

    @Override
    protected int consumeForwardData(ByteBuffer buffer) throws IOException {
        buffer.clear();
        int result = this.reloadFromFileStore(buffer);
        if (result > 0) {
            buffer.flip();
            return result;
        }
        result = this.loadFromStream(buffer);
        if (result >= 0) {
            buffer.flip();
            if (this.persistInFileStore(buffer)) {
                buffer.flip();
            }
        }
        return result;
    }

    private Integer reloadFromFileStore(ByteBuffer buffer) {
        return this.checked(() -> this.withFileLock(() -> this.fileStore.getChannel().read(buffer)));
    }

    private boolean persistInFileStore(ByteBuffer buffer) {
        try {
            this.withFileLock(() -> this.fileStore.getChannel().write(buffer));
            return true;
        }
        catch (IOException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not write in off-heap file store"), (Throwable)e);
        }
    }

    private <T> T checked(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not read from file store"), (Throwable)e);
        }
    }

    private <T> T withFileLock(Callable<T> callable) throws IOException {
        this.fileStoreLock.lock();
        try {
            T t = callable.call();
            return t;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        finally {
            this.fileStoreLock.unlock();
        }
    }

    @Override
    protected void doClose() {
        IOUtils.closeQuietly((Closeable)this.fileStore);
        this.executorService.submit(this.bufferFile::delete);
    }

    private File createBufferFile(String name) {
        return this.createTempFile("mule-buffer-${" + name + "}-", ".tmp");
    }

    private File createTempFile(String prefix, String suffix) throws RuntimeException {
        long n = RANDOM.nextLong();
        n = n == Long.MIN_VALUE ? 0L : Math.abs(n);
        if (!TEMP_DIR.exists()) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Temp directory '%s' does not exist. Please check the value of the '%s' system property.", TEMP_DIR.getAbsolutePath(), TEMP_DIR_SYSTEM_PROPERTY)));
        }
        return new File(TEMP_DIR, prefix + n + suffix);
    }
}

