/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.mule.runtime.core.internal.streaming.bytes.BaseCursorStream;
import org.mule.runtime.core.internal.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.internal.streaming.bytes.CursorStreamProviderAdapter;
import org.mule.runtime.core.internal.streaming.bytes.InputStreamBuffer;

public final class BufferedCursorStream
extends BaseCursorStream {
    private final InputStreamBuffer streamBuffer;
    private final int localBufferSize;
    private final ByteBuffer memoryBuffer;
    private final ByteBufferManager bufferManager;

    public BufferedCursorStream(InputStreamBuffer streamBuffer, ByteBufferManager bufferManager, int localBufferSize, CursorStreamProviderAdapter provider) {
        super(provider);
        this.streamBuffer = streamBuffer;
        this.localBufferSize = localBufferSize;
        this.bufferManager = bufferManager;
        this.memoryBuffer = bufferManager.allocate(localBufferSize);
        this.memoryBuffer.flip();
    }

    @Override
    public void seek(long position) throws IOException {
        super.seek(position);
        this.memoryBuffer.clear();
        this.memoryBuffer.flip();
    }

    @Override
    protected int doRead() throws IOException {
        if (this.reloadLocalBufferIfEmpty(1) > 0) {
            int read = this.unsigned(this.memoryBuffer.get());
            ++this.position;
            return read;
        }
        return -1;
    }

    @Override
    protected int doRead(byte[] b, int off, int len) throws IOException {
        int read = 0;
        int remaining;
        while ((remaining = this.reloadLocalBufferIfEmpty(len)) != -1) {
            if (len <= remaining) {
                this.memoryBuffer.get(b, off, len);
                this.position += (long)len;
                return read + len;
            }
            this.memoryBuffer.get(b, off, remaining);
            this.position += (long)remaining;
            read += remaining;
            off += remaining;
            len -= remaining;
        }
        return read == 0 ? -1 : read;
    }

    private int reloadLocalBufferIfEmpty(int len) {
        if (!this.memoryBuffer.hasRemaining()) {
            this.memoryBuffer.clear();
            int read = this.streamBuffer.get(this.memoryBuffer, this.position, Math.min(this.localBufferSize, len));
            if (read > 0) {
                this.memoryBuffer.flip();
                return read;
            }
            this.memoryBuffer.limit(0);
            return -1;
        }
        return this.memoryBuffer.remaining();
    }

    @Override
    protected void dispose() {
        this.bufferManager.deallocate(this.memoryBuffer);
    }
}

