/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming;

import javax.inject.Inject;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.core.internal.streaming.StreamingManagerAdapter;
import org.mule.runtime.core.internal.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.internal.streaming.bytes.ByteStreamingManagerAdapter;
import org.mule.runtime.core.internal.streaming.bytes.DefaultByteStreamingManager;
import org.mule.runtime.core.internal.streaming.bytes.PoolingByteBufferManager;
import org.mule.runtime.core.streaming.bytes.ByteStreamingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStreamingManager
implements StreamingManagerAdapter,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStreamingManager.class);
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private MuleContext muleContext;
    private ByteBufferManager bufferFactory;
    private ByteStreamingManagerAdapter byteStreamingManager;
    private boolean initialised = false;

    public void initialise() throws InitialisationException {
        if (!this.initialised) {
            this.bufferFactory = new PoolingByteBufferManager();
            this.byteStreamingManager = new DefaultByteStreamingManager(this.bufferFactory, this.schedulerService.ioScheduler(), this.muleContext);
            this.initialised = true;
        }
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.byteStreamingManager, LOGGER);
        LifecycleUtils.disposeIfNeeded(this.bufferFactory, LOGGER);
    }

    @Override
    public ByteStreamingManager forBytes() {
        return this.byteStreamingManager;
    }

    @Override
    public void success(Event event) {
        this.byteStreamingManager.success(event);
    }

    @Override
    public void error(Event event) {
        this.byteStreamingManager.error(event);
    }
}

