/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.context;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.el.context.AbstractMapContext;

class OutboundPropertiesMapContext
extends AbstractMapContext<Serializable> {
    private Event event;
    private Event.Builder eventBuilder;

    public OutboundPropertiesMapContext(Event event, Event.Builder eventBuilder) {
        this.event = event;
        this.eventBuilder = eventBuilder;
    }

    @Override
    public Serializable doGet(String key) {
        return this.event.getMessage().getOutboundProperty(key);
    }

    @Override
    public void doPut(String key, Serializable value) {
        this.eventBuilder.message(InternalMessage.builder(this.event.getMessage()).addOutboundProperty(key, value).build());
        this.event = this.eventBuilder.build();
    }

    @Override
    public void doRemove(String key) {
        this.eventBuilder.message(InternalMessage.builder(this.event.getMessage()).removeOutboundProperty(key).build());
        this.event = this.eventBuilder.build();
    }

    @Override
    public Set<String> keySet() {
        return this.event.getMessage().getOutboundPropertyNames();
    }

    @Override
    public void clear() {
        this.eventBuilder.message(InternalMessage.builder(this.event.getMessage()).outboundProperties(Collections.emptyMap()).build());
        this.event = this.eventBuilder.build();
    }

    public String toString() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        for (String key : this.event.getMessage().getOutboundPropertyNames()) {
            Serializable value = this.event.getMessage().getOutboundProperty(key);
            map.put(key, value);
        }
        return ((Object)map).toString();
    }
}

