/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.config.builders;

import java.io.IOException;
import java.util.Map;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.config.ConfigResource;
import org.mule.runtime.core.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.util.StringUtils;

public abstract class AbstractResourceConfigurationBuilder
extends AbstractConfigurationBuilder {
    private final Map<String, String> artifactProperties;
    protected ConfigResource[] artifactConfigResources;

    public AbstractResourceConfigurationBuilder(String artifactConfigResources, Map<String, String> artifactProperties) throws ConfigurationException {
        this.artifactConfigResources = this.loadConfigResources(StringUtils.splitAndTrim(artifactConfigResources, ",; "));
        this.artifactProperties = artifactProperties;
    }

    public AbstractResourceConfigurationBuilder(String[] artifactConfigResources, Map<String, String> artifactProperties) throws ConfigurationException {
        this.artifactConfigResources = this.loadConfigResources(artifactConfigResources);
        this.artifactProperties = artifactProperties;
    }

    public AbstractResourceConfigurationBuilder(ConfigResource[] artifactConfigResources, Map<String, String> artifactProperties) {
        this.artifactConfigResources = artifactConfigResources;
        this.artifactProperties = artifactProperties;
    }

    @Override
    public void configure(MuleContext muleContext) throws ConfigurationException {
        if (this.artifactConfigResources == null) {
            throw new ConfigurationException(CoreMessages.objectIsNull("Configuration Resources"));
        }
        super.configure(muleContext);
        this.logger.info(CoreMessages.configurationBuilderSuccess((ConfigurationBuilder)this, this.createConfigResourcesString()).toString());
    }

    protected ConfigResource[] loadConfigResources(String[] configs) throws ConfigurationException {
        try {
            this.artifactConfigResources = new ConfigResource[configs.length];
            for (int i = 0; i < configs.length; ++i) {
                this.artifactConfigResources[i] = new ConfigResource(configs[i]);
            }
            return this.artifactConfigResources;
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
    }

    protected String createConfigResourcesString() {
        StringBuilder configResourcesString = new StringBuilder();
        configResourcesString.append("[");
        for (int i = 0; i < this.artifactConfigResources.length; ++i) {
            configResourcesString.append(this.artifactConfigResources[i]);
            if (i >= this.artifactConfigResources.length - 1) continue;
            configResourcesString.append(", ");
        }
        configResourcesString.append("]");
        return configResourcesString.toString();
    }

    public Map<String, String> getArtifactProperties() {
        return this.artifactProperties;
    }
}

