/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.model.resolvers;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleEventContext;
import org.mule.runtime.core.api.model.EntryPointResolver;
import org.mule.runtime.core.api.model.EntryPointResolverSet;
import org.mule.runtime.core.api.model.InvocationResult;
import org.mule.runtime.core.api.model.resolvers.EntryPointNotFoundException;
import org.mule.runtime.core.util.CollectionUtils;

public class DefaultEntryPointResolverSet
implements EntryPointResolverSet {
    private final Set<EntryPointResolver> entryPointResolvers = new LinkedHashSet<EntryPointResolver>(4);

    @Override
    public Object invoke(Object component, MuleEventContext context, Event.Builder eventBuilder) throws Exception {
        HashSet<String> exceptions = new HashSet<String>();
        for (EntryPointResolver resolver : this.entryPointResolvers) {
            InvocationResult result = resolver.invoke(component, context, eventBuilder);
            if (result.getState() == InvocationResult.State.SUCCESSFUL) {
                return result.getResult();
            }
            if (!result.hasError()) continue;
            exceptions.add(result.getErrorMessage());
        }
        throw new EntryPointNotFoundException(CollectionUtils.toString(exceptions, true));
    }

    public Set<EntryPointResolver> getEntryPointResolvers() {
        return this.entryPointResolvers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntryPointResolvers(Set<EntryPointResolver> entryPointResolvers) {
        Set<EntryPointResolver> set = this.entryPointResolvers;
        synchronized (set) {
            this.entryPointResolvers.clear();
            this.entryPointResolvers.addAll(entryPointResolvers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntryPointResolver(EntryPointResolver resolver) {
        Set<EntryPointResolver> set = this.entryPointResolvers;
        synchronized (set) {
            this.entryPointResolvers.add(resolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEntryPointResolver(EntryPointResolver resolver) {
        Set<EntryPointResolver> set = this.entryPointResolvers;
        synchronized (set) {
            return this.entryPointResolvers.remove(resolver);
        }
    }
}

