/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;

abstract class AbstractEventContext
implements EventContext {
    private final List<EventContext> childContexts = new LinkedList<EventContext>();
    private boolean completed = false;
    private boolean streaming = false;

    AbstractEventContext() {
    }

    @Override
    public List<EventContext> getChildContexts() {
        return Collections.unmodifiableList(this.childContexts);
    }

    void addChildContext(EventContext childContext) {
        this.childContexts.add(childContext);
    }

    @Override
    public final void success() {
        this.completed = true;
        this.doSuccess();
    }

    @Override
    public final void success(Event event) {
        this.completed = true;
        this.doSuccess(event);
    }

    @Override
    public final void error(Throwable throwable) {
        this.completed = true;
        this.doError(throwable);
    }

    protected abstract void doSuccess();

    protected abstract void doSuccess(Event var1);

    protected abstract void doError(Throwable var1);

    @Override
    public boolean isTerminated() {
        return this.completed ? this.childContexts.stream().allMatch(EventContext::isTerminated) : false;
    }

    @Override
    public void streaming() {
        this.streaming = true;
    }

    @Override
    public boolean isStreaming() {
        if (this.streaming) {
            return true;
        }
        return this.childContexts.isEmpty() ? false : this.childContexts.stream().anyMatch(EventContext::isStreaming);
    }
}

