/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.queue.objectstore;

import java.io.Serializable;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.store.ObjectStoreException;
import org.mule.runtime.core.util.queue.Queue;
import org.mule.runtime.core.util.queue.QueueSession;
import org.mule.runtime.core.util.queue.objectstore.QueueInfo;
import org.mule.runtime.core.util.queue.objectstore.QueueTransactionContext;
import org.mule.runtime.core.util.queue.objectstore.TransactionalQueueManager;
import org.mule.runtime.core.util.queue.objectstore.xa.AbstractXAResourceManager;
import org.mule.runtime.core.util.queue.objectstore.xa.DefaultXASession;
import org.mule.runtime.core.util.store.DeserializationPostInitialisable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
class TransactionalQueueSession
extends DefaultXASession
implements QueueSession {
    private Logger logger = LoggerFactory.getLogger(org.mule.runtime.core.util.queue.TransactionalQueueSession.class);
    protected TransactionalQueueManager queueManager;

    public TransactionalQueueSession(AbstractXAResourceManager resourceManager, TransactionalQueueManager queueManager) {
        super(resourceManager);
        this.queueManager = queueManager;
    }

    @Override
    public Queue getQueue(String name) {
        QueueInfo queue = this.queueManager.getQueue(name);
        return new QueueImpl(queue);
    }

    protected class QueueImpl
    implements Queue {
        protected QueueInfo queue;

        public QueueImpl(QueueInfo queue) {
            this.queue = queue;
        }

        @Override
        public void put(Serializable item) throws InterruptedException, ObjectStoreException {
            this.offer(item, Long.MAX_VALUE);
        }

        @Override
        public void clear() throws InterruptedException {
            if (TransactionalQueueSession.this.localContext != null && !this.queue.isQueueTransactional()) {
                ((QueueTransactionContext)TransactionalQueueSession.this.localContext).clear(this.queue);
            } else {
                try {
                    TransactionalQueueSession.this.queueManager.doClear(this.queue);
                }
                catch (ObjectStoreException e) {
                    throw new RuntimeException((Throwable)((Object)e));
                }
            }
        }

        @Override
        public boolean offer(Serializable item, long timeout) throws InterruptedException, ObjectStoreException {
            if (TransactionalQueueSession.this.localContext != null && !this.queue.isQueueTransactional()) {
                return ((QueueTransactionContext)TransactionalQueueSession.this.localContext).offer(this.queue, item, timeout);
            }
            try {
                Serializable id = TransactionalQueueSession.this.queueManager.doStore(this.queue, item);
                try {
                    if (!this.queue.offer(id, 0, timeout)) {
                        TransactionalQueueSession.this.queueManager.doRemove(this.queue, id);
                        return false;
                    }
                    return true;
                }
                catch (InterruptedException e) {
                    TransactionalQueueSession.this.queueManager.doRemove(this.queue, id);
                    throw e;
                }
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
        }

        @Override
        public Serializable take() throws InterruptedException {
            return this.poll(Long.MAX_VALUE);
        }

        @Override
        public void untake(Serializable item) throws InterruptedException, ObjectStoreException {
            if (TransactionalQueueSession.this.localContext != null && !this.queue.isQueueTransactional()) {
                ((QueueTransactionContext)TransactionalQueueSession.this.localContext).untake(this.queue, item);
            } else {
                Serializable id = TransactionalQueueSession.this.queueManager.doStore(this.queue, item);
                this.queue.untake(id);
            }
        }

        @Override
        public Serializable poll(long timeout) throws InterruptedException {
            try {
                if (TransactionalQueueSession.this.localContext != null && !this.queue.isQueueTransactional()) {
                    Serializable item = ((QueueTransactionContext)TransactionalQueueSession.this.localContext).poll(this.queue, timeout);
                    return this.postProcessIfNeeded(item);
                }
                if (this.queue.canTakeFromStore()) {
                    Serializable item = this.queue.takeNextItemFromStore(timeout);
                    return this.postProcessIfNeeded(item);
                }
                Serializable id = this.queue.poll(timeout);
                if (id != null) {
                    Serializable item = TransactionalQueueSession.this.queueManager.doLoad(this.queue, id);
                    if (item != null) {
                        TransactionalQueueSession.this.queueManager.doRemove(this.queue, id);
                    }
                    return this.postProcessIfNeeded(item);
                }
                return null;
            }
            catch (InterruptedException iex) {
                if (!TransactionalQueueSession.this.queueManager.getMuleContext().isStopping()) {
                    throw iex;
                }
                return null;
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
        }

        @Override
        public Serializable peek() throws InterruptedException {
            try {
                if (TransactionalQueueSession.this.localContext != null && !this.queue.isQueueTransactional()) {
                    Serializable item = ((QueueTransactionContext)TransactionalQueueSession.this.localContext).peek(this.queue);
                    return this.postProcessIfNeeded(item);
                }
                Serializable id = this.queue.peek();
                if (id != null) {
                    Serializable item = TransactionalQueueSession.this.queueManager.doLoad(this.queue, id);
                    return this.postProcessIfNeeded(item);
                }
                return null;
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
        }

        @Override
        public void dispose() throws MuleException, InterruptedException {
            TransactionalQueueSession.this.queueManager.disposeQueue(this);
        }

        @Override
        public int size() {
            if (TransactionalQueueSession.this.localContext != null && !this.queue.isQueueTransactional()) {
                return ((QueueTransactionContext)TransactionalQueueSession.this.localContext).size(this.queue);
            }
            return this.queue.getSize();
        }

        public String getName() {
            return this.queue.getName();
        }

        private Serializable postProcessIfNeeded(Serializable item) {
            try {
                if (item instanceof DeserializationPostInitialisable) {
                    DeserializationPostInitialisable.Implementation.init(item, TransactionalQueueSession.this.queueManager.getMuleContext());
                }
                return item;
            }
            catch (Exception e) {
                TransactionalQueueSession.this.logger.warn("Unable to deserialize message", (Throwable)e);
                return null;
            }
        }
    }
}

