/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.queue;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.util.queue.QueueConfiguration;
import org.mule.runtime.core.util.queue.QueueManager;
import org.mule.runtime.core.util.queue.QueueSession;
import org.mule.runtime.core.util.queue.objectstore.TransactionalQueueManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegateQueueManager
implements QueueManager,
Lifecycle,
MuleContextAware {
    public static final String MULE_QUEUE_OLD_MODE_KEY = "mule.queue.objectstoremode";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private QueueManager delegate;

    public DelegateQueueManager() {
        if (DelegateQueueManager.isOldModeEnabled()) {
            this.logger.info("Using old QueueManager implementation");
            this.delegate = new TransactionalQueueManager();
        } else {
            this.delegate = new org.mule.runtime.core.util.queue.TransactionalQueueManager();
        }
    }

    @Override
    public QueueSession getQueueSession() {
        return this.delegate.getQueueSession();
    }

    @Override
    public void setDefaultQueueConfiguration(QueueConfiguration config) {
        this.delegate.setDefaultQueueConfiguration(config);
    }

    @Override
    public void setQueueConfiguration(String queueName, QueueConfiguration config) {
        this.delegate.setQueueConfiguration(queueName, config);
    }

    public void start() throws MuleException {
        this.delegate.start();
    }

    public void stop() throws MuleException {
        this.delegate.stop();
    }

    public void dispose() {
        if (this.delegate instanceof Disposable) {
            ((Disposable)this.delegate).dispose();
        }
    }

    public void initialise() throws InitialisationException {
        if (this.delegate instanceof Initialisable) {
            ((Initialisable)this.delegate).initialise();
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        if (this.delegate instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.delegate)).setMuleContext(context);
        }
    }

    public static boolean isOldModeEnabled() {
        return Boolean.getBoolean(MULE_QUEUE_OLD_MODE_KEY);
    }

    QueueManager getDelegate() {
        return this.delegate;
    }
}

