/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;

public final class TimedSocket {
    private static final int WATCHDOG_FREQUENCY = 100;

    private TimedSocket() {
    }

    public static Socket createSocket(String host, int port, int timeout) throws IOException {
        SocketConnector connector = new SocketConnector(host, port);
        connector.start();
        int timer = 0;
        while (!connector.isConnected()) {
            if (connector.hasException()) {
                throw connector.getException();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException unexpectedInterruption) {
                throw new InterruptedIOException("Connection interruption: " + unexpectedInterruption.getMessage());
            }
            if ((timer += 100) < timeout) continue;
            throw new InterruptedIOException("Connection timeout on " + host + ":" + port + " after " + timer + " milliseconds");
        }
        return connector.getSocket();
    }

    static class SocketConnector
    extends Thread {
        private volatile Socket connectedSocket;
        private String host;
        private int port;
        private IOException exception;

        public SocketConnector(String host, int port) {
            this.host = host;
            this.port = port;
        }

        @Override
        public void run() {
            try {
                this.connectedSocket = new Socket(this.host, this.port);
            }
            catch (IOException ioe) {
                this.exception = ioe;
            }
        }

        public boolean isConnected() {
            return this.connectedSocket != null;
        }

        public boolean hasException() {
            return this.exception != null;
        }

        public Socket getSocket() {
            return this.connectedSocket;
        }

        public IOException getException() {
            return this.exception;
        }
    }
}

