/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.simple;

import java.io.Serializable;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.AbstractAnnotatedObject;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.util.AttributeEvaluator;
import org.mule.runtime.core.util.WildcardAttributeEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyPropertiesProcessor
extends AbstractAnnotatedObject
implements Processor,
MuleContextAware,
Initialisable {
    private static final Logger logger = LoggerFactory.getLogger(CopyPropertiesProcessor.class);
    private AttributeEvaluator propertyNameEvaluator;
    private WildcardAttributeEvaluator wildcardPropertyNameEvaluator;
    private MuleContext muleContext;

    public void initialise() throws InitialisationException {
        this.propertyNameEvaluator.initialize(this.muleContext.getExpressionManager());
    }

    @Override
    public Event process(Event event) throws MuleException {
        Event.Builder resultBuilder = Event.builder(event);
        InternalMessage message = event.getMessage();
        if (this.wildcardPropertyNameEvaluator.hasWildcards()) {
            InternalMessage.Builder builder = InternalMessage.builder(message);
            this.wildcardPropertyNameEvaluator.processValues(message.getInboundPropertyNames(), matchedValue -> builder.addOutboundProperty(matchedValue, message.getInboundProperty(matchedValue), message.getInboundPropertyDataType(matchedValue)));
            resultBuilder.message(builder.build());
        } else {
            Object keyValue = this.propertyNameEvaluator.resolveValue(event);
            if (keyValue != null) {
                String propertyName = keyValue.toString();
                Serializable propertyValue = message.getInboundProperty(propertyName);
                if (propertyValue != null) {
                    resultBuilder.message(InternalMessage.builder(message).addOutboundProperty(propertyName, propertyValue, message.getInboundPropertyDataType(propertyName)).build());
                } else {
                    logger.info("Property value for is null, no property will be copied");
                }
            } else {
                logger.info("Key expression return null, no property will be copied");
            }
        }
        return resultBuilder.build();
    }

    public Object clone() throws CloneNotSupportedException {
        CopyPropertiesProcessor clone = (CopyPropertiesProcessor)super.clone();
        clone.setPropertyName(this.propertyNameEvaluator.getRawValue());
        return clone;
    }

    public void setPropertyName(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Null propertyName not supported");
        }
        this.propertyNameEvaluator = new AttributeEvaluator(propertyName);
        this.wildcardPropertyNameEvaluator = new WildcardAttributeEvaluator(propertyName);
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

