/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.encryption;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.streaming.CursorStreamProvider;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.security.CryptoFailureException;
import org.mule.runtime.core.api.security.EncryptionStrategy;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.transformer.AbstractTransformer;

public abstract class AbstractEncryptionTransformer
extends AbstractTransformer
implements MuleContextAware {
    private EncryptionStrategy strategy = null;
    private String strategyName = null;

    public AbstractEncryptionTransformer() {
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.STRING);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.registerSourceType(DataType.CURSOR_STREAM_PROVIDER);
        this.setReturnDataType(DataType.INPUT_STREAM);
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractEncryptionTransformer clone = (AbstractEncryptionTransformer)super.clone();
        clone.setStrategy(this.strategy);
        clone.setStrategyName(this.strategyName);
        return clone;
    }

    @Override
    public Object doTransform(Object src, Charset outputEncoding) throws TransformerException {
        Object input = src instanceof String ? new ByteArrayInputStream(src.toString().getBytes()) : (src instanceof CursorStreamProvider ? ((CursorStreamProvider)src).openCursor() : (src instanceof InputStream ? (InputStream)src : new ByteArrayInputStream((byte[])src)));
        try {
            return this.primTransform((InputStream)input);
        }
        catch (CryptoFailureException e) {
            throw new TransformerException(this, (Throwable)((Object)e));
        }
    }

    protected abstract InputStream primTransform(InputStream var1) throws CryptoFailureException;

    @Override
    public void initialise() throws InitialisationException {
        if (this.strategyName != null) {
            if (this.muleContext.getSecurityManager() == null) {
                if (this.strategy == null) {
                    throw new InitialisationException(CoreMessages.authSecurityManagerNotSet(), (Initialisable)this);
                }
            } else {
                this.strategy = this.muleContext.getSecurityManager().getEncryptionStrategy(this.strategyName);
            }
        }
        if (this.strategy == null) {
            throw new InitialisationException(CoreMessages.encryptionStrategyNotSet(), (Initialisable)this);
        }
        LifecycleUtils.initialiseIfNeeded(this.strategy);
    }

    public EncryptionStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(EncryptionStrategy strategy) {
        this.strategy = strategy;
    }

    public String getStrategyName() {
        return this.strategyName;
    }

    public void setStrategyName(String strategyName) {
        this.strategyName = strategyName;
    }
}

