/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.transform.stream.StreamSource;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.MultiPartPayload;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.AbstractAnnotatedObject;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.transformer.AbstractMessageTransformer;
import org.mule.runtime.core.transformer.TransformerUtils;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.core.util.StringMessageUtils;
import org.mule.runtime.core.util.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransformer
extends AbstractAnnotatedObject
implements Transformer {
    protected MuleContext muleContext;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile DataType returnType = null;
    protected String name = null;
    protected final List<DataType> sourceTypes = new CopyOnWriteArrayList<DataType>();
    private boolean ignoreBadInput = false;
    private boolean allowNullReturn = false;

    @Override
    public Event process(Event event) throws MuleException {
        if (event != null && event.getMessage() != null) {
            try {
                return Event.builder(event).message(this.muleContext.getTransformationService().applyTransformers(event.getMessage(), event, this)).build();
            }
            catch (Exception e) {
                throw new MessageTransformerException(this, e);
            }
        }
        return event;
    }

    protected void registerSourceType(DataType dataType) {
        if (!this.sourceTypes.contains(dataType)) {
            this.sourceTypes.add(dataType);
            if (dataType.getType().equals(Object.class)) {
                this.logger.debug("java.lang.Object has been added as source type for this transformer, there will be no source type checking performed");
            }
        }
    }

    protected void unregisterSourceType(DataType dataType) {
        this.sourceTypes.remove(dataType);
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.generateTransformerName();
        }
        return this.name;
    }

    public void setName(String string) {
        if (string == null) {
            string = ClassUtils.getSimpleName(this.getClass());
        }
        this.logger.debug("Setting transformer name to: " + string);
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReturnDataType(DataType type) {
        AbstractTransformer abstractTransformer = this;
        synchronized (abstractTransformer) {
            this.returnType = type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataType getReturnDataType() {
        if (this.returnType == null) {
            AbstractTransformer abstractTransformer = this;
            synchronized (abstractTransformer) {
                if (this.returnType == null) {
                    this.returnType = DataType.builder().charset(SystemUtils.getDefaultEncoding(this.muleContext)).build();
                }
            }
        }
        return this.returnType;
    }

    public boolean isAllowNullReturn() {
        return this.allowNullReturn;
    }

    public void setAllowNullReturn(boolean allowNullReturn) {
        this.allowNullReturn = allowNullReturn;
    }

    @Override
    public boolean isSourceDataTypeSupported(DataType dataType) {
        return this.isSourceDataTypeSupported(dataType, false);
    }

    public boolean isSourceDataTypeSupported(DataType dataType, boolean exactMatch) {
        int numTypes = this.sourceTypes.size();
        if (numTypes == 0) {
            return !exactMatch;
        }
        for (DataType sourceType : this.sourceTypes) {
            if (!(exactMatch ? sourceType.equals(dataType) : sourceType.isCompatibleWith(dataType))) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Object transform(Object src) throws TransformerException {
        return this.transform(src, this.resolveEncoding(src));
    }

    protected Charset resolveEncoding(Object src) {
        return this.getReturnDataType().getMediaType().getCharset().orElse(this.getEncoding(src));
    }

    private Charset getEncoding(Object src) {
        if (src instanceof InternalMessage) {
            return ((InternalMessage)src).getPayload().getDataType().getMediaType().getCharset().orElse(SystemUtils.getDefaultEncoding(this.muleContext));
        }
        return SystemUtils.getDefaultEncoding(this.muleContext);
    }

    @Override
    public Object transform(Object src, Charset enc) throws TransformerException {
        DataType sourceType;
        Object payload = src;
        if (src instanceof InternalMessage) {
            InternalMessage message = (InternalMessage)src;
            if (!this.isSourceDataTypeSupported(DataType.MULE_MESSAGE, true) && !(this instanceof AbstractMessageTransformer)) {
                src = ((InternalMessage)src).getPayload().getValue();
                payload = message.getPayload().getValue();
            }
        }
        if (MultiPartPayload.class.isAssignableFrom((sourceType = DataType.fromObject((Object)payload)).getType())) {
            I18nMessage msg = I18nMessageFactory.createStaticMessage((String)"\"%s\" cannot be transformed to %s.", (Object[])new Object[]{MultiPartPayload.class.getSimpleName(), this.getReturnDataType().getType().getName()});
            throw new TransformerException(msg, this);
        }
        if (!this.isSourceDataTypeSupported(sourceType)) {
            I18nMessage msg = CoreMessages.transformOnObjectUnsupportedTypeOfEndpoint(this.getName(), payload.getClass());
            throw new TransformerException(msg, this);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Applying transformer %s (%s)", this.getName(), this.getClass().getName()));
            this.logger.debug(String.format("Object before transform: %s", StringMessageUtils.toString(payload)));
        }
        Object result = this.doTransform(payload, enc);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Object after transform: %s", StringMessageUtils.toString(result)));
        }
        TransformerUtils.checkTransformerReturnClass(this, result);
        return result;
    }

    protected boolean isConsumed(Class<?> srcCls) {
        return InputStream.class.isAssignableFrom(srcCls) || StreamSource.class.isAssignableFrom(srcCls);
    }

    protected abstract Object doTransform(Object var1, Charset var2) throws TransformerException;

    public void initialise() throws InitialisationException {
    }

    public void dispose() {
    }

    protected String generateTransformerName() {
        return TransformerUtils.generateTransformerName(this.getClass(), this.getReturnDataType());
    }

    @Override
    public List<DataType> getSourceDataTypes() {
        return Collections.unmodifiableList(this.sourceTypes);
    }

    @Override
    public boolean isIgnoreBadInput() {
        return this.ignoreBadInput;
    }

    public void setIgnoreBadInput(boolean ignoreBadInput) {
        this.ignoreBadInput = ignoreBadInput;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append(ClassUtils.getSimpleName(this.getClass()));
        sb.append("{this=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", ignoreBadInput=").append(this.ignoreBadInput);
        sb.append(", returnClass=").append(this.getReturnDataType());
        sb.append(", sourceTypes=").append(this.sourceTypes);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean isAcceptNull() {
        return false;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

