/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.source.polling.watermark;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;

public abstract class WatermarkUtils {
    public static Serializable evaluate(String expression, Event event, MuleContext muleContext) throws NotSerializableException {
        ExtendedExpressionManager expressionManager = muleContext.getExpressionManager();
        if (expressionManager.isExpression(expression) && expressionManager.isValid(expression)) {
            Object evaluated = expressionManager.evaluate(expression, event).getValue();
            if (evaluated != null && !(evaluated instanceof Serializable)) {
                throw new NotSerializableException(String.format("Expression %s resolves to an object that is not serializable (%s). It can't be used as watermark.", expression, evaluated.getClass().getCanonicalName()));
            }
            return (Serializable)evaluated;
        }
        return expression;
    }
}

