/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.source.polling;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.lifecycle.CreateException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.source.polling.PeriodicScheduler;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.context.notification.ConnectorMessageNotification;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.execution.TransactionalErrorHandlingExecutionTemplate;
import org.mule.runtime.core.source.polling.MessageProcessorPollingInterceptor;
import org.mule.runtime.core.source.polling.MessageProcessorPollingOverride;
import org.mule.runtime.core.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingMessageSource
implements MessageSource,
FlowConstructAware,
Startable,
Stoppable,
MuleContextAware,
Initialisable,
Disposable {
    private static Logger logger = LoggerFactory.getLogger(PollingMessageSource.class);
    private final PeriodicScheduler scheduler;
    private Scheduler pollingExecutor;
    private ScheduledFuture<?> pollingJob;
    private Processor listener;
    private FlowConstruct flowConstruct;
    private MuleContext muleContext;
    protected Processor sourceMessageProcessor;
    protected MessageProcessorPollingOverride override;

    public PollingMessageSource(MuleContext muleContext, Processor sourceMessageProcessor, MessageProcessorPollingOverride override, PeriodicScheduler scheduler) {
        this.muleContext = muleContext;
        this.sourceMessageProcessor = sourceMessageProcessor;
        this.override = override;
        this.scheduler = scheduler;
    }

    public void start() throws MuleException {
        try {
            if (this.override instanceof Startable) {
                ((Startable)this.override).start();
            }
            if (this.sourceMessageProcessor instanceof Startable) {
                ((Startable)this.sourceMessageProcessor).start();
            }
            this.pollingJob = this.scheduler.schedule(this.pollingExecutor, () -> this.performPoll());
        }
        catch (Exception ex) {
            this.stop();
            throw new CreateException(CoreMessages.failedToScheduleWork(), ex, this);
        }
    }

    public String getPollingUniqueName() {
        return this.flowConstruct.getName() + "-polling-" + this.hashCode();
    }

    public void stop() throws MuleException {
        if (this.override instanceof Stoppable) {
            ((Stoppable)this.override).stop();
        }
        if (this.pollingJob != null) {
            this.pollingJob.cancel(false);
            this.pollingJob = null;
        }
    }

    public final void performPoll() {
        Event.setCurrentEvent(null);
        if (!this.pollOnPrimaryInstanceOnly() || this.flowConstruct.getMuleContext().isPrimaryPollingInstance()) {
            this.poll();
        }
    }

    private boolean pollOnPrimaryInstanceOnly() {
        return true;
    }

    public void poll() {
        InternalMessage request = InternalMessage.builder().payload("").build();
        this.pollWith(request);
    }

    private void pollWith(final InternalMessage request) {
        TransactionalErrorHandlingExecutionTemplate executionTemplate = TransactionalErrorHandlingExecutionTemplate.createMainExecutionTemplate(this.muleContext, this.flowConstruct, this.flowConstruct.getExceptionListener());
        try {
            Event muleEvent;
            final MessageProcessorPollingInterceptor interceptor = this.override.interceptor();
            if (interceptor instanceof MuleContextAware) {
                ((MuleContextAware)((Object)interceptor)).setMuleContext(this.muleContext);
            }
            if ((muleEvent = executionTemplate.execute(new ExecutionCallback<Event>(){

                @Override
                public Event process() throws Exception {
                    return ClassUtils.withContextClassLoader(PollingMessageSource.this.muleContext.getExecutionClassLoader(), () -> {
                        Event event = Event.builder(DefaultEventContext.create(PollingMessageSource.this.flowConstruct, PollingMessageSource.this.getPollingUniqueName())).message(request).flow(PollingMessageSource.this.flowConstruct).build();
                        event = interceptor.prepareSourceEvent(event);
                        Event.setCurrentEvent(event);
                        Event sourceEvent = PollingMessageSource.this.sourceMessageProcessor.process(event);
                        if (PollingMessageSource.this.isNewMessage(sourceEvent)) {
                            PollingMessageSource.this.muleContext.getNotificationManager().fireNotification(new ConnectorMessageNotification(this, sourceEvent.getMessage(), PollingMessageSource.this.getPollingUniqueName(), PollingMessageSource.this.flowConstruct, 801));
                            event = interceptor.prepareRouting(sourceEvent, sourceEvent, PollingMessageSource.this.flowConstruct);
                            interceptor.postProcessRouting(PollingMessageSource.this.listener.process(event));
                        } else {
                            logger.info(CoreMessages.pollSourceReturnedNull(PollingMessageSource.this.flowConstruct.getName()).getMessage());
                        }
                        return null;
                    }, Exception.class, e -> {
                        throw e;
                    });
                }
            })) != null) {
                interceptor.postProcessRouting(muleEvent);
            }
        }
        catch (MessagingException interceptor) {
        }
        catch (Exception e) {
            this.muleContext.getExceptionListener().handleException(e);
        }
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.sourceMessageProcessor, this.muleContext, this.flowConstruct);
        LifecycleUtils.initialiseIfNeeded((Object)this.override, this.muleContext, this.flowConstruct);
        this.createScheduler();
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.sourceMessageProcessor, logger);
        LifecycleUtils.disposeIfNeeded(this.override, logger);
        this.disposeScheduler();
    }

    private void createScheduler() throws InitialisationException {
        this.pollingExecutor = this.muleContext.getSchedulerService().ioScheduler();
    }

    private void disposeScheduler() {
        if (this.pollingExecutor != null) {
            this.pollingExecutor.stop((long)this.muleContext.getConfiguration().getShutdownTimeout(), TimeUnit.MILLISECONDS);
            this.pollingExecutor = null;
        }
    }

    protected boolean isNewMessage(Event event) {
        if (event != null && event.getMessage() != null) {
            InternalMessage message = event.getMessage();
            return message.getPayload().getValue() != null;
        }
        return false;
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void setListener(Processor listener) {
        this.listener = listener;
    }
}

