/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing.filters;

import java.util.Optional;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.message.ExceptionPayload;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.routing.filters.PayloadTypeFilter;
import org.mule.runtime.core.util.ClassUtils;

public class ExceptionTypeFilter
extends PayloadTypeFilter {
    public ExceptionTypeFilter() {
    }

    public ExceptionTypeFilter(String expectedType) throws ClassNotFoundException {
        this(ClassUtils.loadClass(expectedType, ExceptionTypeFilter.class));
    }

    public ExceptionTypeFilter(Class expectedType) {
        super(expectedType);
    }

    @Override
    public boolean accept(Event event, Event.Builder builder) {
        Optional<Error> errorOptional = event.getError();
        if (this.getExpectedType() == null) {
            return errorOptional.isPresent();
        }
        if (errorOptional.isPresent()) {
            return this.getExpectedType().isAssignableFrom(errorOptional.get().getCause().getClass());
        }
        return this.accept(event.getMessage(), builder);
    }

    @Override
    public boolean accept(InternalMessage message, Event.Builder builder) {
        ExceptionPayload epl = message.getExceptionPayload();
        if (this.getExpectedType() == null) {
            return epl != null;
        }
        if (epl != null) {
            return this.getExpectedType().isAssignableFrom(epl.getException().getClass());
        }
        return false;
    }
}

